clr.AddReference("System.Management")
clr.AddReference("TWC.Executioner")
clr.AddReference("I2Common")
clr.AddReference("TWC.I2Libs")
clr.AddReference("TWC.Util")
clr.AddReference("TWC.I2FSharpLib")

from System import Convert
from System import Environment
from System import DateTime
from System import TimeSpan
from System import String
from System.Globalization import CultureInfo
from System.Management import CimType
from System.Management import WqlObjectQuery
from System.Management import ManagementObjectSearcher
from System.Management import ManagementObject
from System.Management import PropertyDataCollection
from System.Management import PropertyData
from TWC.I2.FS import GetBiosInfoJob
from TWC.I2.Util import Config
from TWC.Util import Toolbox
from TWC.Util.JobProcessor import JobContext


def Run(doc):

	root = doc.CreateElement("MachineInfo")
	
	#OS Info
	opSysQuery = WqlObjectQuery("SELECT * FROM Win32_OperatingSystem")
	searcher = ManagementObjectSearcher(opSysQuery)	
	for item in searcher.Get():
		
		namedProps = [["OSName", "Name"], ["OSVersion", "Version"], ["TotalVisibleMemorySize", "TotalVisibleMemorySize"]]		
		AddProps(doc, root, item, namedProps)
		
		clrver = doc.CreateElement("CLRVersion")
		clrvertxt = doc.CreateTextNode(Environment.Version.ToString())
		clrver.AppendChild(clrvertxt)
		root.AppendChild(clrver)				
		
		localDateTime = item.Properties["LocalDateTime"].Value
		lastBootUpTime = item.Properties["LastBootUpTime"].Value		
		localDateTime = localDateTime.Substring(0, localDateTime.IndexOf('.'))
		lastBootUpTime = lastBootUpTime.Substring(0, lastBootUpTime.IndexOf('.'))		
		localDateTime = DateTime.ParseExact(localDateTime, "yyyyMMddHHmmss", CultureInfo.InvariantCulture)
		lastBootUpTime = DateTime.ParseExact(lastBootUpTime, "yyyyMMddHHmmss", CultureInfo.InvariantCulture)
		
		upTime = (localDateTime - lastBootUpTime)		
		upt = doc.CreateElement("UPTime")
		upttxt = doc.CreateTextNode(Convert.ToString(upTime))
		upt.AppendChild(upttxt)
		root.AppendChild(upt)
		
	#Logical Disks	
	logicalDiskQuery = WqlObjectQuery("SELECT * FROM Win32_LogicalDisk")
	searcher = ManagementObjectSearcher(logicalDiskQuery)
		
	for disk in searcher.Get():		
		drive = doc.CreateElement("DriveInfo")
		namedProps = [["Name","Name"], ["Description","Description"], ["Caption","Caption"], ["FileSystem","FileSystem"], ["FreeSpace","FreeSpace"], ["Size","Size"]]		
		AddProps(doc, drive, disk, namedProps)		
		root.AppendChild(drive)
		
	#GraphicsCardInfo
	graphicsCardQuery = WqlObjectQuery("SELECT * FROM Win32_VideoController")
	searcher = ManagementObjectSearcher(graphicsCardQuery)
	
	for item in searcher.Get():
		gcInfo = doc.CreateElement("GraphicsCardInfo")
		namedProps = [["Name","Name"], ["DeviceID", "DeviceID"], ["Description","Description"], ["InstalledDisplayDrivers","InstalledDisplayDrivers"], ["DriverVersion", "DriverVersion"], ["DriverDate" , "DriverDate"],  ["CurrentHorizontalResolution","CurrentHorizontalResolution"], ["CurrentVerticalResolution","CurrentVerticalResolution"] ,["Status", "Status"]]
		AddProps(doc, gcInfo, item, namedProps)
		root.AppendChild(gcInfo)
	
	#TStormCardInfo
	#Bios
	d = GetBiosInfoJob.getBiosInfoJob(JobContext(), "")
	root.AppendChild(doc.ImportNode(d.DocumentElement, True))
		
	doc.DocumentElement.AppendChild(root)
	
def AddProps(doc, root, item, namedProps):
	for x in range(0,len(namedProps)):
		propName = namedProps[x][0]
		propValue = namedProps[x][1]

		if item.Properties[propValue] != None:	
	
			name = doc.CreateElement(propName)
			value = Convert.ToString(item.Properties[propValue].Value)
			if String.IsNullOrEmpty(value) == False and item.Properties[propValue].Type == CimType.DateTime:
				#The date that WMI reports is CimType date which is incompatible with .Net DateTime
				#The format is YYYYMMDDHHMMSS.MMMMMM(+-)OOO so custom conversion is required
				value = value.Substring(0, value.IndexOf("."))
				nametxt = doc.CreateTextNode(DateTime.ParseExact(value, "yyyyMMddHHmmss", CultureInfo.InvariantCulture).ToShortDateString())
			else:
				nametxt = doc.CreateTextNode(value)
			name.AppendChild(nametxt)
			root.AppendChild(name)
	