clr.AddReference("I2Common")
clr.AddReference("TWC.I2Libs")
clr.AddReference("TWC.Util")
clr.AddReference("System")

from TWC.I2.PlaylistManagement import ProductConfig
from TWC.I2.Util import MachineConfigManager
from TWC.I2.Util.DataAccess import DataAccessLayer
from TWC.Util import DataViewTimes

def Run(doc):
	
	mcm = MachineConfigManager()
	root = doc.CreateElement("MachineConfigInfo")
	headendId = mcm.GetHeadendId()
	headend = doc.CreateElement("HeadendID")
	headendtxt = doc.CreateTextNode(headendId)
	headend.AppendChild(headendtxt)
	root.AppendChild(headend)
		
	dal = DataAccessLayer()
	identity = dal.Get("identity", "identity")
	serial = identity.SelectSingleNode("identity/serialNumber")
	if serial != None:
		serialNumber = doc.CreateElement("SerialNumber")
		serialNumberTxt = doc.CreateTextNode(serial.InnerText)
		serialNumber.AppendChild(serialNumberTxt)
		root.AppendChild(serialNumber)

	headendName = identity.SelectSingleNode("identity/HeadendName")
	if headendName != None:
		heName = doc.CreateElement("HeadendName")
		heNameTxt = doc.CreateTextNode(headendName.InnerText)
		heName.AppendChild(heNameTxt)
		root.AppendChild(heName)

	disableLocalization = identity.SelectSingleNode("identity/disableLocalization")
	if disableLocalization != None:
		disLoc = doc.CreateElement("DisableLocalization")
		disLocTxt = doc.CreateTextNode(disableLocalization.InnerText)
		disLoc.AppendChild(disLocTxt)
		root.AppendChild(disLoc)
	
	flags = mcm.GetFlags()
	starFlags = doc.CreateElement("StarFlags")
	for x in range(0, len(flags)):
		f = doc.CreateElement("Flag")
		ftxt = doc.CreateTextNode(flags[x])
		f.AppendChild(ftxt)
		starFlags.AppendChild(f)
		
	root.AppendChild(starFlags)
	doc.DocumentElement.AppendChild(root)