clr.AddReference("System.Management")
clr.AddReference("TWC.Executioner")
clr.AddReference("TWC.I2Libs")
clr.AddReference("TWC.Util")
clr.AddReference("TWC.I2FSharpLib")

from System import Convert
from System import Environment
from System import DateTime
from System import TimeSpan
from System import String
from System.Globalization import CultureInfo
from System.Management import CimType
from System.Management import WqlObjectQuery
from System.Management import ManagementObjectSearcher
from System.Management import ManagementObject
from System.Management import PropertyDataCollection
from System.Management import PropertyData
from TWC.I2.FS import GetBiosInfoJob
from TWC.I2.Util import Config
from TWC.Util import Toolbox
from TWC.Util.JobProcessor import JobContext


def Run(doc):

	now = DateTime.Now 
	root = doc.CreateElement("EventLog")
	systemNode = doc.CreateElement("System")
	root.AppendChild(systemNode)
	applicationNode = doc.CreateElement("Application")
	root.AppendChild(applicationNode)
	
	#System Event Log Info
	eventLogQuery = WqlObjectQuery("SELECT * FROM Win32_NTLogEvent Where Logfile = 'System' ")
	searcher = ManagementObjectSearcher(eventLogQuery)	
			
	for event in searcher.Get():		
		logNode = doc.CreateElement("Event")
		namedProps = [["RecordNumber","RecordNumber"],["ComputerName","ComputerName"], ["Category","Category"], ["CategoryString","CategoryString"], ["EventCode","EventCode"], ["SourceName","SourceName"], ["Type","Type"], ["EventType","EventType"],  ["Message","Message"], ["TimeWritten","TimeWritten"]]		
		AddProps(doc, logNode, event, namedProps)		
		systemNode.AppendChild(logNode)
		
	#Application Event Log Info
	eventLogQuery = WqlObjectQuery("SELECT * FROM Win32_NTLogEvent Where Logfile = 'Application'")
	searcher = ManagementObjectSearcher(eventLogQuery)	
			
	for event in searcher.Get():		
		logNode = doc.CreateElement("Event")
		namedProps = [["RecordNumber","RecordNumber"],["ComputerName","ComputerName"], ["Category","Category"], ["CategoryString","CategoryString"], ["EventCode","EventCode"], ["SourceName","SourceName"], ["Type","Type"], ["EventType","EventType"],  ["Message","Message"], ["TimeWritten","TimeWritten"]]				
		AddProps(doc, logNode, event, namedProps)		
		applicationNode.AppendChild(logNode)
		
	doc.DocumentElement.AppendChild(root)
	
def AddProps(doc, root, item, namedProps):
	for x in range(0,len(namedProps)):
		propName = namedProps[x][0]
		propValue = namedProps[x][1]

		if item.Properties[propValue] != None:	
	
			name = doc.CreateElement(propName)
			value = Convert.ToString(item.Properties[propValue].Value)
			if String.IsNullOrEmpty(value) == False and item.Properties[propValue].Type == CimType.DateTime:
				#The date that WMI reports is CimType date which is incompatible with .Net DateTime
				#The format is YYYYMMDDHHMMSS.MMMMMM(+-)OOO so custom conversion is required
				value = value.Substring(0, value.IndexOf("."))
				nametxt = doc.CreateTextNode(DateTime.ParseExact(value, "yyyyMMddHHmmss", CultureInfo.InvariantCulture).ToString())
			else:
				nametxt = doc.CreateTextNode(value)
			name.AppendChild(nametxt)
			root.AppendChild(name)
	