const fs = require("fs")
const path = require("path")
/**
 * Get info on Rainwater Map Data
 * @returns {}
 */
module.exports = function mapData() {
    const map_directory = path.join(__dirname, "../../images/maps/")
    const maps = [
        {
            name: "CONUS Radar for IStar",
            apiName: "radar-us",
            file: "radar-us.py",
            clearAfter: 3 * 60 * 60,
            runEvery: 2 * 60
        },
        {
            name: "Puerto Rico Radar for IStar",
            apiName: "radar-pr",
            file: "radar-pr.py",
            clearAfter: 3 * 60 * 60,
            runEvery: 5 * 60
        },
        {
            name: "Alaska Radar for IStar",
            apiName: "radar-ak",
            file: "radar-ak.py",
            clearAfter: 3 * 60 * 60,
            runEvery: 5 * 60
        },
        {
            name: "Hawaii Radar for IStar",
            apiName: "radar-hi",
            file: "radar-hi.py",
            clearAfter: 3 * 60 * 60,
            runEvery: 5 * 60
        },
        {
            name: "CONUS SatRad for IStar",
            apiName: "satrad-us",
            file: "satrad-us.py",
            clearAfter: 3 * 60 * 60,
            runEvery: 5 * 60
        }
    ]
    const out = {}
    maps.forEach(map => {
        out[map.apiName] = map
        out[map.apiName].directory = path.join(map_directory, map.apiName)
        out[map.apiName].dirsNeeded = [path.join(map_directory, map.apiName, "temp"), path.join(map_directory, map.apiName, "tiles")]
    })
    return out
};