/**
 * Convert V1 TWC Daily Fcst + IStar LFRecord to IStar 1 CC
 * @param {Object} input - V1 API Daily Fcst Data as Json
 * @returns {}
 */
module.exports = function daily(input) {
    let data = `
import twccommon
import time
import twc.dsmarshal as dsm

areaList = wxdata.getUGCInterestList('${input.county}', 'county')

twccommon.Log.info("RWE - Daily Forecast is being sent")
if not areaList:
    abortMsg()

Y, M, D, h, m, s, wd, jd, dst = time.localtime(time.time())
if h < 16:
    dOffset = 0
else:
    dOffset = 1
keyTime = time.mktime((Y, M, D + dOffset, 0, 0, 0, 0, 0, -1))
    `
    input.forecasts.forEach(fcst => {
        const day = `
for area in areaList:
    forecastTime_${fcst.num} = keyTime = (${fcst.num - 1} * 86400)
    b_${fcst.num} = twc.Data()
    ${fcst.max_temp ? `b_${fcst.num}.highTemp = ${fcst.max_temp || "None"}` : ""}
    b_${fcst.num}.lowTemp = ${fcst.min_temp || "None"}
    ${fcst.day?.icon_extd ? `b_${fcst.num}.daySkyCondition = ${fcst.day.icon_extd || "None"}` : ""}
    b_${fcst.num}.eveningSkyCondition = ${fcst.night.icon_extd || "None"}        
    wxdata.setData(('${input.location}.' + str(int(forecastTime_${fcst.num})), 'dailyFcst', b_${fcst.num}, int(forecastTime_${fcst.num} + 86400)))
    twccommon.Log.info("RWE - Daily forecast data has been set")

`

data += day
})
return data
};