const mqtt = require('mqtt');
const fs = require('fs');
const path = require('path');
const config = require("./config.json")

const crypto = require('crypto');

let client = null;

const lastSent = new Map()

const {WebhookClient, EmbedBuilder} = require("discord.js")
const LOG_WEBHOOK = new WebhookClient({url:"https://discord.com/api/webhooks/1424859568659234979/OgwzchDqub1Rw1DnWZgtFDO1oW3yfhl3Z4BQ48pjZNz_Wrjl17ef86qFs6ZLntRj03Lp"})

async function checkAllTopics() {
  const watchpointsPath = path.join(__dirname, "monitoring-watchpoints.json");
  const watchpoints = JSON.parse(fs.readFileSync(watchpointsPath));

  console.log("Loaded watchpoints:", watchpoints);
  console.log("Last sent topics:", Array.from(lastSent.keys()));
  console.log("Debug - checking");

  for (const topic of lastSent.keys()) {
      const lastReceived = lastSent.get(topic);
      const wp = watchpoints[topic];

      if (!wp) {
          console.warn(`No watchpoint found for topic: ${topic}`);
          continue;
      }

      const now = Date.now();
      const timeSinceLast = (now - lastReceived) / 1000;

      console.log(`Monitoring & checking ${topic}`);
      console.log(`Time since last packet: ${timeSinceLast}s, Threshold: ${wp.watchpoint}s`);

      if (timeSinceLast > wp.watchpoint) {
          console.warn(`No packet from ${topic} in ${timeSinceLast}s (threshold: ${wp.watchpoint}s)`);
          console.warn(`Topic is considered ${wp.priority}`);

          if (wp.priority === "HIGH_PRI") {
              exec("logMessage(File={0},Message=Restarting Rainwater MQTT due to watchpoint error)", "i2/data" );
              const child_process = require("child_process");
              child_process.exec("pm2 restart 14");
              child_process.exec("pm2 restart 15");
              LOG_WEBHOOK.send({content:`Rebooted ENCODER SERVER due to data not being sent within threshold time limit (${topic} - threshold of ${wp.watchpoint}s - pri: ${wp.priority})`})
          }
          if(wp.priority === "LOW_PRI") {
            LOG_WEBHOOK.send({content:`<@415123009016299520> Low priority topic has not been sending packets. ENCODER will continue running unless issue occurs >3 times. Topic = ${topic} with threshold of ${wp.watchpoint}s`})
          }
      }
  }
}

checkAllTopics()
setInterval(() => checkAllTopics(), 5 * 1000)

function connect(options = {}) {
  const {
    url = `ws://${config.address}:${config.port}/mqtt`,
    username = config.mainWistKey,
  } = options;

  return new Promise((resolve, reject) => {
    client = mqtt.connect(url, { username });

    client.once('connect', () => {
      console.log('[+] Connected to MQTT broker');
      LOG_WEBHOOK.send({content:"Connected to Encoder successfully"})
      resolve(client);
    });
    client.subscribe("#")
    client.on('packetreceive', (packet) => {
        lastSent.set(packet.topic, new Date() / 1)
        console.log(`Just received packet from ${packet.topic}`)
        //console.log(packet)
    })

    client.once('error', (err) => {
      console.error('[!] MQTT Error:', err);
      reject(err);
    });
  });
}

connect()

function publishAsync(topic, message) {
  return new Promise(async (resolve, reject) => {
    if (!client || !client.connected) {connect()}
    await connect()
    client.publish(topic, message, (err) => {
      if (err) return reject(err);
      resolve();
    });
  });
}

async function sendJson(topic, payload = {}) {
  const message = JSON.stringify(payload);
  await publishAsync(topic, message);
}

async function sendI2Data(dataType, payload, topic = "i2/data") {
  const message = {
    fileName: dataType + '.i2m',
    data: payload,
    workRequest: 'storeData(File={filepath})',
    payloadType: "i2mData"
  };
  await publishAsync(topic, JSON.stringify(message));
}

async function sendI2DataTopical(dataType, payload, topic) {
  const message = {
    fileName: dataType + '.i2m',
    data: payload,
    workRequest: 'storeData(File={filepath})',
    payloadType: "i2mData"
  };
  await publishAsync(topic, JSON.stringify(message));
}

async function exec(command, topic) {
  const message = {
    workRequest: command
  };
  setTimeout(async () => {
    await publishAsync(topic, JSON.stringify(message));
  }, Math.round(Math.random() * 750));
}

//exec("logMessage(Message=Sorry for any outages! This is still a beta and issues may occur. We appreciate youre patience as a rainwater data user!)", "i2/data")
//exec("logMessage(Message=Hourly forecast has been fixed! You should now receive hourly fcst data.)", "i2/data")

//exec("logMessage(Message=Thank you for using the new rainwater encoder! We appreciate all of our testers!)", "i2/data")
//exec("logMessage(Message=Thank You and Good Night)", "i2/data")
exec("logMessage(File={0},Message=This IntelliSTAR is sponsored by DqFuqBOOM for the Skibidi Toilet ad campaign.)", "i2/data")
//exec("logMessage(Message=I2 Data is brought to you by Rainwater. You are connected to STARSRV CENTRAL 1 out of Minneapolis Minnesota.)", "i2/data")

//exec("loadRunPres(Flavor=domestic/azul i2 jr,Duration=3600,PresentationId=4)", "i2/bundles/airpod")
const ntpClient = require('ntp-client');

function formatToMMDDYYYY_HHMMSS(date) {
  const pad = (n) => n.toString().padStart(2, '0');
  return `${pad(date.getUTCMonth() + 1)}/${pad(date.getUTCDate())}/${date.getUTCFullYear()} ${pad(date.getUTCHours())}:${pad(date.getUTCMinutes())}:${pad(date.getUTCSeconds())}`;
}


async function heartbeat() {

  ntpClient.getNetworkTime("time.nist.gov", 123, (err, date) => {
    if(err) {
      console.error(err);
      return;
    }
    exec("Sending heartbeat for beta v17+", "i2/heartbeat")
    //exec(`heartbeat(Time=${formatToMMDDYYYY_HHMMSS(new Date(date + 2000))})`, "i2/heartbeat")
  });

}

function getRandomBackground(unitType) {
  if(unitType == "xd") {
    const db = require("./xd.json")
    return (db[Math.floor(Math.random() * db.length)].ID || db[0].ID)
  } else {
    const db = require("./jr.json")
    return (db[Math.floor(Math.random() * db.length)].ID || db[0].ID)
  }
}

//heartbeat()

function getNextCueDelay(every, onthe) {
  const now = new Date();
  const currentMinutes = now.getMinutes();
  const currentSeconds = now.getSeconds();

  const cueMinutes = [];
  for (let m = onthe; m < 60; m += every) {
    cueMinutes.push(m);
  }

  let targetHour = now.getHours();
  let targetMinute = null;

  for (const m of cueMinutes) {
    if (m > currentMinutes || (m === currentMinutes && currentSeconds < 55)) {
      targetMinute = m;
      break;
    }
  }

  if (targetMinute === null) {
    // No cue left this hour; roll over to next hour
    targetHour = (targetHour + 1) % 24;
    const tomorrow = new Date(now);
    if (targetHour === 0) tomorrow.setDate(now.getDate() + 1);

    return new Date(
      tomorrow.getFullYear(),
      tomorrow.getMonth(),
      tomorrow.getDate(),
      targetHour,
      cueMinutes[0],
      0,
      0
    ).getTime() - now.getTime();
  }

  return new Date(
    now.getFullYear(),
    now.getMonth(),
    now.getDate(),
    targetHour,
    targetMinute,
    0,
    0
  ).getTime() - now.getTime();
}

async function startCueCycle(data) {
  let lastCueTime = 0;
  let cueData = data;
  const topic = cueData.topic || "i2/overflow/unknown";

  while (true) {
    const delay = getNextCueDelay(cueData.timing.every, cueData.timing.onthe) - 60000; // 1 min early
    const actualDelay = Math.max(delay, 2000);
    const nextCueTime = new Date(Date.now() + actualDelay);
    const now = Date.now();

    if (now - lastCueTime < 125000) {
      console.warn(`[!] Skipping near-duplicate cue for "${topic}"`);
      await new Promise(res => setTimeout(res, 3000));
      continue;
    }

    console.log(`Next cue for "${topic}" in ${Math.round(actualDelay / 1000)} seconds...`);

    await new Promise(resolve => setTimeout(resolve, actualDelay));
    lastCueTime = Date.now();

    try {
      const startFlavors = [{ id: "ldl3", flavor: cueData.ldl, duration: 54000 }];

      if (cueData.sidebar.enabled) {
        startFlavors.push({ id: "sidebar2", flavor: cueData.sidebar.flavor, duration: 2680 });
      }

      let bg = cueData.background == 0 ? null : `domesticAds/TAG${cueData.background}`;
      if (cueData.background == 9) {
        bg = `domesticAds/TAG${getRandomBackground(cueData.unitType)}`;
      }
      if (`${cueData.background}`.startsWith("domesticAds/TAG")) {
        bg = cueData.background;
      }

      if (cueData.enabled === true) {
        const allCues = JSON.parse(fs.readFileSync(path.join(__dirname, "cues.json"), "utf8"));
        cueData = Object.values(allCues).find(c => c.topic === topic) || cueData;

        await sendI2Playlist(
          topic,
          cueData.flavor,
          cueData.duration,
          4,
          bg,
          58,
          [{ id: "ldl3" }, { id: "sidebar2" }],
          startFlavors
        );
      }
    } catch (e) {
      console.error(`Failed to execute cue for "${topic}":`, e);
      await new Promise(res => setTimeout(res, 3000)); // prevent instant retry
    }
  }
}

//exec("changeTimeZone(TimeZoneString=Central Standard Time)", "i2/bundles/airpod")

const runningCues = new Map()

async function startCues() {
  const data = JSON.parse(fs.readFileSync(path.join(__dirname, "cues.json"), "utf8"));
  
  for (const cueName in data) {
    if (data.hasOwnProperty(cueName)) {
      const cueData = data[cueName];

      if (!runningCues.has(cueData.topic)) {
        runningCues.set(cueData.topic, true);
        startCueCycle(cueData);  // Assuming startCueCycle expects cueData
      }
    }
  }
}

function formatStart(time) {
    const date = new Date(time);
    const pad = (num, size) => num.toString().padStart(size, '0');
    const month = pad(date.getUTCMonth() + 1, 2);
    const day = pad(date.getUTCDate(), 2);
    const year = date.getUTCFullYear();
    const hours = pad(date.getUTCHours(), 2);
    const minutes = pad(date.getUTCMinutes(), 2);
    const seconds = pad(date.getUTCSeconds(), 2);
    return `${month}/${day}/${year} ${hours}:${minutes}:${seconds}:00`;
}


async function sendI2Playlist(topic, flavor, duration, id, tag, delay, cancelInfo, startInfo) {
  const file = "{0}"; // Replace this with actual file or pass as param

  const loadCommand = `loadPres(File=${file},Flavor=${flavor},Duration=${duration},PresentationId=${id}${tag ? `,Logo=${tag}` : ""})`;

  const baseTime = new Date();
  if (delay !== null && delay !== undefined) {
      baseTime.setSeconds(baseTime.getSeconds() + delay + 2); // buffer of 2 seconds
  }

  const runCommand = `runPres(File=${file},PresentationId=${id},StartTime=${formatStart(baseTime)})`;

  const cancelCommands = (cancelInfo ?? []).map(c => {
      return {
          command: `cancelPres(File=${file},PresentationId=${c.id},StartTime=${formatStart(baseTime)})`,
          delay: Math.max((delay ?? 0) * 1000 - 10000, 0)
      };
  });

  const presentationDurationMs = (duration * 1000) / 30;
  const followupLoadOffset = Math.max(presentationDurationMs - 35000, 0);
  const followupRunOffset = Math.max(presentationDurationMs - 25000, 0);

  const startCommands = (startInfo ?? []).map(c => {
      const startTime = new Date(Date.now() + presentationDurationMs + (delay ? delay * 1000 : 0) + 2000);
      return {
          load: {
              command: `loadPres(File=${file},Flavor=${c.flavor},Duration=${c.duration},PresentationId=${c.id})`,
              delay: Math.max(((delay ?? 0) * 1000) + followupLoadOffset, 0)
          },
          run: {
              command: `runPres(File=${file},PresentationId=${c.id},StartTime=${formatStart(startTime)})`,
              delay: Math.max(((delay ?? 0) * 1000) + followupRunOffset, 0)
          }
      };
  });

  try {
      console.log("Executing loadCommand:", loadCommand);
      await exec(loadCommand, topic);

      cancelCommands.forEach(({ command, delay }) => {
          console.log(`Scheduling cancelCommand after ${delay}ms:`, command);
          setTimeout(async () => {
              try {
                  await exec(runCommand, topic); // just in case
                  await exec(runCommand, topic);
                  await exec(command, topic);
              } catch (e) {
                  console.error("Cancel command failed:", command, e);
              }
          }, delay);
      });

      if (delay !== null && delay !== undefined) {
          setTimeout(async () => {
              try {
                  console.log("Executing runCommand after delay:", runCommand);
                  await exec(runCommand, topic);

                  startCommands.forEach(c => {
                      console.log(`Scheduling follow-up loadCommand after ${c.load.delay}ms:`, c.load.command);
                      setTimeout(async () => {
                          try {
                              await exec(c.load.command, topic);
                          } catch (e) {
                              console.error("Follow-up load failed:", c.load.command, e);
                          }
                      }, c.load.delay);

                      console.log(`Scheduling follow-up runCommand after ${c.run.delay}ms:`, c.run.command);
                      setTimeout(async () => {
                          try {
                              await exec(c.run.command, topic);
                          } catch (e) {
                              console.error("Follow-up run failed:", c.run.command, e);
                          }
                      }, c.run.delay);
                  });
              } catch (e) {
                  console.error("Initial runCommand failed:", runCommand, e);
              }
          }, 5000);
      } else {
          console.log("Executing runCommand immediately:", runCommand);
          await exec(runCommand, topic);

          startCommands.forEach(c => {
              console.log(`Scheduling follow-up loadCommand after ${followupLoadOffset}ms:`, c.load.command);
              setTimeout(async () => {
                  try {
                      await exec(c.load.command, topic);
                  } catch (e) {
                      console.error("Follow-up load failed:", c.load.command, e);
                  }
              }, followupLoadOffset);

              console.log(`Scheduling follow-up runCommand after ${followupRunOffset}ms:`, c.run.command);
              setTimeout(async () => {
                  try {
                      await exec(c.run.command, topic);
                  } catch (e) {
                      console.error("Follow-up run failed:", c.run.command, e);
                  }
              }, followupRunOffset);
          });
      }

  } catch (err) {
      console.error("Error occurred while handling playlist:", err);
      return null;
  }
}


async function sendI2Radar(location, filePath, filename = null, imageType, ts) {
  if (!fs.existsSync(filePath)) throw new Error(`File not found: ${filePath}`);

  const fileBuffer = fs.readFileSync(filePath);
  const base64Data = fileBuffer.toString('base64');

  const message = JSON.stringify({
    fileName: filename || path.basename(filePath),
    data: base64Data,
    location,
    imageType,
    workRequest: `storePriorityImage(File={filepath},IssueTime=${formatIssueTime(ts)},Location=${location},ImageType=${imageType},FileExtension=.${filename.split(".")[1]},FileName=${ts}.${filename.split(".")[1]})`,
    payloadType: "i2Radar"
  });
  await publishAsync('i2/radar', message);
}

const zipLib = require('zip-lib');
const { v4: uuidv4 } = require('uuid');

const tempDir = path.join(__dirname, 'temp');
if (!fs.existsSync(tempDir)) fs.mkdirSync(tempDir);

const generateTempFileName = () => uuidv4();

const generateXML = (fileActions, type) => {
  const now = new Date();
  const formattedDate = `${now.getMonth() + 1}/${now.getDate()}/${now.getFullYear()}`;


  let xmlContent = `
<StarBundle>
  <Version>${638764964506688900 + (new Date() / 1)}</Version>
  <ApplyDate>${formattedDate}</ApplyDate>
  <Type>${type}</Type>
  <FileActions>
`;
    const data= {HeadendIds:["1","2"],version:638764964506688900 + (new Date() / 1)}

      let currentVersion = Number(data.version);

  fileActions.forEach(({ src, dest }) => {
    currentVersion += 1000;
    const cleanedDest = dest.replaceAll("SD_", "").replaceAll("/", "\\");
    data.HeadendIds.forEach(() => {
      const platform = "Domestic_Universe";
      xmlContent += `    <Add src="${src}" dest="${cleanedDest}" version="${currentVersion}" />\n`;
      //xmlContent += `    <Add src="${src}" dest="${cleanedDest}" version="${currentVersion}" />\n`;
    });
  });

  data.version = currentVersion;

  xmlContent += `  </FileActions>
</StarBundle>`;

  return xmlContent;
};

async function sendMachineProductCfg(xmlText, topic) {
  await exec("resetAllStarBundleVersions(BType=Managed)", topic)
  const vPath = "Config/MachineProductCfg.xml";
  const tempName = generateTempFileName();
  const tempFilePath = path.join(tempDir, tempName);

  // Write the XML content to a temp file
  fs.writeFileSync(tempFilePath, xmlText, 'utf8');

  const fileActions = [{ src: tempName, dest: vPath, ogFileName: 'virtual' }];
  const manifestXML = generateXML(fileActions, "Managed");

  // Write manifest.xml to temp
  const metadataDir = path.join(tempDir, 'MetaData');
  if(!fs.existsSync(metadataDir)) {
    fs.mkdirSync(metadataDir);
  }
  const manifestFilePath = path.join(metadataDir, 'manifest.xml');
  fs.writeFileSync(manifestFilePath, manifestXML, "utf-8");

  // Create the zip
  const zip = new zipLib.Zip();
  zip.addFile(tempFilePath);
  zip.addFile(manifestFilePath, 'MetaData\\manifest.xml');

  const filename = `${Math.floor(Math.random() * 100000000000)}_MPC_StarBundle.zip`;
  const zipFilePath = path.join(tempDir, filename);
  await zip.archive(zipFilePath);

  // Read and send
  const fileBuffer = fs.readFileSync(zipFilePath);
  const base64Data = fileBuffer.toString('base64');

  const message = JSON.stringify({
    fileName: filename,
    data: base64Data,
    workRequest: `stageStarBundle(File={filepath})`,
    payloadType: "i2StarBundle"
  });

  await publishAsync(topic, message);
  console.log(`✅ Bundle sent to topic "${topic}" as "${filename}"`);
  fs.readdirSync(path.join(tempDir, "MetaData")).forEach(f => {fs.rmSync(path.join(tempDir, "MetaData", f))})
  fs.rmdirSync(path.join(tempDir, "MetaData"));
  fs.readdirSync(path.join(tempDir)).forEach(f => {fs.rmSync(path.join(tempDir, f))})

  fs.rmdirSync(tempDir);
  fs.mkdirSync(tempDir)
  setTimeout(async () => {
    await exec(`changeTimeZone(TimeZoneString=${xmlText.split(`<ConfigItem key="timeZone" value="`)[1].split('"')[0]})`, topic)
  }, 3000);
  updateLocations(xmlText)
}

async function sendI2Bundle(filePath, filename = null) {
  if (!fs.existsSync(filePath)) throw new Error(`File not found: ${filePath}`);

  const fileBuffer = fs.readFileSync(filePath);
  const base64Data = fileBuffer.toString('base64');

  const message = JSON.stringify({
    fileName: filename || path.basename(filePath),
    data: base64Data,
    workRequest: `stageStarBundle(File={filepath})`,
    payloadType: "i2StarBundle"
  });
  await publishAsync('i2/bundles/dev', message);
}

//sendMachineProductCfg(fs.readFileSync("Duluth_mn.xml", "utf-8"), "i2/17895179")


async function sendFakeAlert(alertType, alertName, alertBulletin, alertHeadline, starId, expireTime) {
  const db = JSON.parse(fs.readFileSync(path.join(__dirname, "cues.json"), "utf-8"))
  let location = "MNZ001"
  if(db[starId]) {
    if(db[starId].location) {
      location = db[starId].location.primZone
    }
  }
  const alert = await generateAlert(alertType, alertName, alertBulletin, alertHeadline, location, expireTime, db[starId].location.display)

  await sendI2DataTopical("BERecord", alert, db[starId].topic)
}

//sendI2Bundle("./638764734249670000.zip", "638764734249670000.zip")

function formatIssueTime(ts) {
  const date = new Date(ts * 1000)
  return `${String(date.getUTCMonth() + 1).padStart(2, 0)}/${String(date.getUTCDate()).padStart(2, 0)}/${date.getUTCFullYear()} ${String(date.getUTCHours()).padStart(2, 0)}:${String(date.getUTCMinutes()).padStart(2, 0)}:${String(date.getUTCSeconds()).padStart(2, 0)}`
}

function generateChecksum(data) {
    const bPIL = data.BERecord.BEHdr[0].bPIL[0];  // WSW
    const eActionCd = data.BERecord.BEHdr[0].bEvent[0].eActionCd[0];  // CON
    const ePhenom = data.BERecord.BEHdr[0].bEvent[0].ePhenom[0];  // BZ
    const eSgnfcnc = data.BERecord.BEHdr[0].bEvent[0].eSgnfcnc[0];  // W
    const eETN = data.BERecord.BEHdr[0].bEvent[0].eETN[0];  // 0001
    const eDesc = data.BERecord.BEHdr[0].bEvent[0].eDesc[0];  // Blizzard Warning
    const eExpTmUTC = data.BERecord.BEHdr[0].bEvent[0].eExpTmUTC[0];  // 202411210000
    const bLocCd = data.BERecord.BEHdr[0].bLocations[0].bLocCd[0];  // NDZ002
    const bCntryCd = data.BERecord.BEHdr[0].bLocations[0].bCntryCd[0];  // US
    const bTzAbbrv = data.BERecord.BEHdr[0].bLocations[0].bTzAbbrv[0];  // CST
    
    const concatenatedString = [
        bPIL, eActionCd, ePhenom, eSgnfcnc, eETN, eDesc, eExpTmUTC,
        bLocCd, bCntryCd, bTzAbbrv
    ].join("|");
    
    const checksum = crypto.createHash('md5').update(concatenatedString).digest('hex');
    return checksum;
}

async function generateAlert(alertGenericType, alertName, alertBulletin, alertHeadline, location, expireTime, display) {
    //if(!(alertGenericType == "WS_W" || alertGenericType == "BZ_W" || alertGenericType == "TO_W" || alertGenericType == "GENERIC" )) return `<Data type="BERecord" \\>`
    const zone = location
    const eventTrackingNumber = Math.round(Math.random() * 100).toString().slice(0, 4).padStart(4, 0)
    let alertFinalGenericType = ((alertGenericType.toUpperCase() == "GENERIC") ? "TO_W" : alertGenericType)
    console.log(`Generated ${alertName} alert successfully.`)
    return `<Data type="BERecord">
    <BERecord id="0000" locationKey="${zone}_${alertFinalGenericType}_${eventTrackingNumber}_KTDN" isWxscan="0">
        <action>NOT_USED</action>
        <BEHdr>
            <bPIL>${alertFinalGenericType.split("_").join("")}</bPIL>
            <bWMOHdr>NOT_USED</bWMOHdr>
            <bEvent>
                <eActionCd eActionPriority="1">CON</eActionCd>
                <eOfficeId eOfficeNm="TheDalkNetwork">KTDN</eOfficeId>
                <ePhenom>${alertFinalGenericType.split("_")[0]}</ePhenom>
                <eSgnfcnc>${alertFinalGenericType.split("_")[1]}</eSgnfcnc>
                <eETN>${eventTrackingNumber}</eETN>
                <eDesc>${alertName}</eDesc>
                <eStTmUTC>NOT_USED</eStTmUTC>
                <eEndTmUTC>${formatDate(new Date(expireTime))}</eEndTmUTC>
                <eSvrty>1</eSvrty>
                <eTWCIId>NOT_USED</eTWCIId>
                <eExpTmUTC>${formatDate(new Date(expireTime))}</eExpTmUTC>
            </bEvent>
            <bLocations>
                <bLocCd bLoc="${display.split(", ")[0]}" bLocTyp="Z">${zone}</bLocCd>
                <bStCd bSt="${display.split(", ")[1]}">${display.split(", ")[1]}</bStCd>
                <bUTCDiff>NOT_USED</bUTCDiff>
                <bTzAbbrv>CST</bTzAbbrv>
                <bCntryCd>US</bCntryCd>
            </bLocations>
            <bSgmtChksum>${generateChecksum({BERecord:{BEHdr:[{bPIL:["Test"],bEvent:[{eActionCd:["CON"],ePhenom:[alertGenericType.split("_")[0]],eSgnfcnc:[alertGenericType.split("_")[1]],eETN:[eventTrackingNumber],eDesc:[alertName],eExpTmUTC:[formatDate(new Date(expireTime))]}],bLocations:[{bLocCd:[zone],bCntryCd:["US"],bTzAbbrv:"CST"}]}]}})}</bSgmtChksum>
            <procTm>${formatDateOther(new Date())}</procTm>
        </BEHdr>
        <BEData>
            <bIssueTmUTC>${formatDate(new Date())}</bIssueTmUTC>
            <bHdln>
                <bHdlnTxt>${alertHeadline}</bHdlnTxt>
                ${getVocalHeadline(alertGenericType)}
            </bHdln>
            <bNarrTxt bNarrTxtLang="en-US">
                <bLn>${alertBulletin}</bLn>
            </bNarrTxt>
            <bSrchRslt>NOT_USED</bSrchRslt>
        </BEData>
        <clientKey>${zone}_${alertFinalGenericType}_${eventTrackingNumber}_KTDN</clientKey>
    </BERecord>
</Data>`;
}
const { XMLParser } = require('fast-xml-parser');
const locationsFile = path.join(__dirname, 'locations.json');

function updateLocations(xmlStr) {
  const parser = new XMLParser({
    ignoreAttributes: false,
    attributeNamePrefix: '',
  });
  let xml;
  try {
    xml = parser.parse(xmlStr);
  } catch (e) {
    console.error('Failed to parse XML:', e);
    return;
  }

  const keysToCheck = [
    'LocalRadarCity', 'MapCity', 'MetroMapCity', 'NearbyLocation',
    'RegionalMapCity', 'WinterGetawayLocation', 'TravelCity', 'SummerGetawayLocation'
  ];

  const allCities = new Set();
  const alertItems = new Set();

  let configItems = [];
  try {
    const items = xml?.Config?.ConfigDef?.ConfigItems?.ConfigItem;
    if (!items) return;

    configItems = Array.isArray(items) ? items : [items];
  } catch {
    return;
  }

  for (const item of configItems) {
    const key = item.key || item['key'] || (item['@_key']) || null;
    const value = item.value || item['value'] || (item['@_value']) || null;

    if (!key || !value) continue;

    // Check numbered keys
    for (let i = 1; i <= 8; i++) {
      for (const baseKey of keysToCheck) {
        if (key === `${baseKey}${i}`) {
          allCities.add(value);
        }
      }
    }

    // Check special keys
    if (key === 'PrimaryLocation') allCities.add(value);

    if (key === 'primaryZone') alertItems.add(value);
    if (key === 'primaryCounty') alertItems.add(value);

    if (key === 'secondaryZones') {
      value.split(',').map(v => v.trim()).forEach(v => alertItems.add(v));
    }

    if (key === 'secondaryCounties') {
      value.split(',').map(v => v.trim()).forEach(v => alertItems.add(v));
    }
  }

  let locations = { general: [], alerts: [], national: [] };
  try {
    locations = JSON.parse(fs.readFileSync(locationsFile, 'utf8'));
  } catch {
  }

  allCities.forEach(c => {
    if (!locations.general.includes(c)) locations.general.push(c);
  });

  alertItems.forEach(a => {
    if (!locations.alerts.includes(a)) locations.alerts.push(a);
  });

  fs.writeFileSync(locationsFile, JSON.stringify(locations, null, 2));
  console.log('Updated locations.json');
}

/* setInterval(() => {
  activeClients.forEach((data, clientId) => {
    try {
      const payload = fs.readFileSync(data.filePath, 'utf8');
      const packet = {
        topic: 'connection/machineproductcfg',
        payload: JSON.stringify({ timestamp: Date.now(), data: payload })
      };
      aedes.publish(packet);
    } catch {}
  });
}, 5 * 60 * 1000); */

function getVocalHeadline(vocalCode) {
    const vocalCodeMap = {
        'HU_W': '<bVocHdlnCd>HE001</bVocHdlnCd>',
        'TY_W': '<bVocHdlnCd>HE002</bVocHdlnCd>',
        'HI_W': '<bVocHdlnCd>HE003</bVocHdlnCd>',
        'TO_A': '<bVocHdlnCd>HE004</bVocHdlnCd>',
        'SV_A': '<bVocHdlnCd>HE005</bVocHdlnCd>',
        'HU_A': '<bVocHdlnCd>HE006</bVocHdlnCd>',
        'TY_A': '<bVocHdlnCd>HE007</bVocHdlnCd>',
        'TR_W': '<bVocHdlnCd>HE008</bVocHdlnCd>',
        'TR_A': '<bVocHdlnCd>HE009</bVocHdlnCd>',
        'TI_W': '<bVocHdlnCd>HE010</bVocHdlnCd>',
        'HI_A': '<bVocHdlnCd>HE011</bVocHdlnCd>',
        'TI_A': '<bVocHdlnCd>HE012</bVocHdlnCd>',
        'BZ_W': '<bVocHdlnCd>HE013</bVocHdlnCd>',
        'IS_W': '<bVocHdlnCd>HE014</bVocHdlnCd>',
        'WS_W': '<bVocHdlnCd>HE015</bVocHdlnCd>',
        'HW_W': '<bVocHdlnCd>HE016</bVocHdlnCd>',
        'LE_W': '<bVocHdlnCd>HE017</bVocHdlnCd>',
        'ZR_Y': '<bVocHdlnCd>HE018</bVocHdlnCd>',
        'CF_W': '<bVocHdlnCd>HE019</bVocHdlnCd>',
        'LS_W': '<bVocHdlnCd>HE020</bVocHdlnCd>',
        'WW_Y': '<bVocHdlnCd>HE021</bVocHdlnCd>',
        'LB_Y': '<bVocHdlnCd>HE022</bVocHdlnCd>',
        'LE_Y': '<bVocHdlnCd>HE023</bVocHdlnCd>',
        'BZ_A': '<bVocHdlnCd>HE024</bVocHdlnCd>',
        'WS_A': '<bVocHdlnCd>HE025</bVocHdlnCd>',
        'FF_A': '<bVocHdlnCd>HE026</bVocHdlnCd>',
        'FA_A': '<bVocHdlnCd>HE027</bVocHdlnCd>',
        'FA_Y': '<bVocHdlnCd>HE028</bVocHdlnCd>',
        'HW_A': '<bVocHdlnCd>HE029</bVocHdlnCd>',
        'LE_A': '<bVocHdlnCd>HE030</bVocHdlnCd>',
        'SU_W': '<bVocHdlnCd>HE031</bVocHdlnCd>',
        'LS_Y': '<bVocHdlnCd>HE032</bVocHdlnCd>',
        'CF_A': '<bVocHdlnCd>HE033</bVocHdlnCd>',
        'ZF_Y': '<bVocHdlnCd>HE034</bVocHdlnCd>',
        'FG_Y': '<bVocHdlnCd>HE035</bVocHdlnCd>',
        'SM_Y': '<bVocHdlnCd>HE036</bVocHdlnCd>',
        'EC_W': '<bVocHdlnCd>HE037</bVocHdlnCd>',
        'EH_W': '<bVocHdlnCd>HE038</bVocHdlnCd>',
        'HZ_W': '<bVocHdlnCd>HE039</bVocHdlnCd>',
        'FZ_W': '<bVocHdlnCd>HE040</bVocHdlnCd>',
        'HT_Y': '<bVocHdlnCd>HE041</bVocHdlnCd>',
        'WC_Y': '<bVocHdlnCd>HE042</bVocHdlnCd>',
        'FR_Y': '<bVocHdlnCd>HE043</bVocHdlnCd>',
        'EC_A': '<bVocHdlnCd>HE044</bVocHdlnCd>',
        'EH_A': '<bVocHdlnCd>HE045</bVocHdlnCd>',
        'HZ_A': '<bVocHdlnCd>HE046</bVocHdlnCd>',
        'DS_W': '<bVocHdlnCd>HE047</bVocHdlnCd>',
        'WI_Y': '<bVocHdlnCd>HE048</bVocHdlnCd>',
        'SU_Y': '<bVocHdlnCd>HE049</bVocHdlnCd>',
        'AS_Y': '<bVocHdlnCd>HE050</bVocHdlnCd>',
        'WC_W': '<bVocHdlnCd>HE051</bVocHdlnCd>',
        'FZ_A': '<bVocHdlnCd>HE052</bVocHdlnCd>',
        'WC_A': '<bVocHdlnCd>HE053</bVocHdlnCd>',
        'AF_W': '<bVocHdlnCd>HE054</bVocHdlnCd>',
        'AF_Y': '<bVocHdlnCd>HE055</bVocHdlnCd>',
        'DU_Y': '<bVocHdlnCd>HE056</bVocHdlnCd>',
        'LW_Y': '<bVocHdlnCd>HE057</bVocHdlnCd>',
        'LS_A': '<bVocHdlnCd>HE058</bVocHdlnCd>',
        'HF_W': '<bVocHdlnCd>HE059</bVocHdlnCd>',
        'SR_W': '<bVocHdlnCd>HE060</bVocHdlnCd>',
        'GL_W': '<bVocHdlnCd>HE061</bVocHdlnCd>',
        'HF_A': '<bVocHdlnCd>HE062</bVocHdlnCd>',
        'UP_W': '<bVocHdlnCd>HE063</bVocHdlnCd>',
        'SE_W': '<bVocHdlnCd>HE064</bVocHdlnCd>',
        'SR_A': '<bVocHdlnCd>HE065</bVocHdlnCd>',
        'GL_A': '<bVocHdlnCd>HE066</bVocHdlnCd>',
        'MF_Y': '<bVocHdlnCd>HE067</bVocHdlnCd>',
        'MS_Y': '<bVocHdlnCd>HE068</bVocHdlnCd>',
        'SC_Y': '<bVocHdlnCd>HE069</bVocHdlnCd>',
        'UP_Y': '<bVocHdlnCd>HE073</bVocHdlnCd>',
        'LO_Y': '<bVocHdlnCd>HE074</bVocHdlnCd>',
        'AF_V': '<bVocHdlnCd>HE075</bVocHdlnCd>',
        'UP_A': '<bVocHdlnCd>HE076</bVocHdlnCd>',
        'TAV_W': '<bVocHdlnCd>HE077</bVocHdlnCd>',
        'TAV_A': '<bVocHdlnCd>HE078</bVocHdlnCd>',
        'TO_W': '<bVocHdlnCd>HE110</bVocHdlnCd>',
        "GENERIC": '<bVocHdlnCd />',
    };
    
    const vocalCodeEnd = vocalCodeMap[vocalCode] || '<bVocHdlnCd />';
    return vocalCodeEnd
}

function formatDate(time) {
    const now = new Date(time);
    const year = String(now.getUTCFullYear());
    const month = String(now.getUTCMonth() + 1).padStart(2, '0');
    const day = String(now.getUTCDate()).padStart(2, '0');
    const hours = String(now.getUTCHours()).padStart(2, '0');
    const minutes = String(now.getUTCMinutes()).padStart(2, '0');
    const seconds = String(now.getUTCSeconds()).padStart(2, '0');
    return `${year}${month}${day}${hours}${minutes}`; // YYHHDDNNMM
}

function formatDateOther(time) {
    const now = new Date(time);
    const year = String(now.getFullYear());
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const day = String(now.getDate()).padStart(2, '0');
    const hours = String(now.getHours()).padStart(2, '0');
    const minutes = String(now.getMinutes()).padStart(2, '0');
    const seconds = String(now.getSeconds()).padStart(2, '0');
    return `${year}${month}${day}${hours}${minutes}${seconds}`; // YYHHDDNNMM
}

async function sendFileAsBase64(topic, filePath, filename = null) {
  if (!fs.existsSync(filePath)) throw new Error(`File not found: ${filePath}`);

  const fileBuffer = fs.readFileSync(filePath);
  const base64Data = fileBuffer.toString('base64');

  const message = JSON.stringify({
    fileName: filename || path.basename(filePath),
    data: base64Data
  });

  await publishAsync(topic, message);
}

async function sendRaw(topic, data) {
  await publishAsync(topic, data);
}

function disconnect() {
  //if (client) client.end();
}

module.exports = {
  connect
};
