const config = require('./config.json');
const path = require("node:path");
const fs = require("node:fs");

const DEBUG_FILE_PATH = path.join(__dirname, "debug.txt");
const LOG_FLUSH_INTERVAL = 5 * 60 * 1000; // 5 minutes
const logBuffer = [];

if (!fs.existsSync(DEBUG_FILE_PATH)) {
    fs.writeFileSync(DEBUG_FILE_PATH, "First write to Debug logs\n", "utf-8");
}

function flushLogs() {
    if (logBuffer.length === 0) return;
    const logData = logBuffer.join('\n') + '\n';
    fs.appendFileSync(DEBUG_FILE_PATH, logData, "utf-8");
    logBuffer.length = 0; // clear buffer
}

setInterval(flushLogs, LOG_FLUSH_INTERVAL);

process.on('exit', flushLogs);
process.on('SIGINT', () => {
    flushLogs();
    process.exit();
});
process.on('SIGTERM', () => {
    flushLogs();
    process.exit();
});

function centerText(text, width = 50) {
    const spaces = Math.max(0, Math.floor((width - text.length) / 2));
    return ' '.repeat(spaces) + text + ' '.repeat(spaces);
}

function intro(arg) {
    const width = 50;
    const now = new Date();

    console.clear();
    console.log(centerText('##########################################', width));
    console.log(centerText('WIST MQTT STAR DATA', width));
    console.log(centerText(`Today is ${now.toLocaleDateString('en-US', {
        weekday: 'long', year: 'numeric', month: 'long', day: 'numeric'
    })}`, width));
    console.log(centerText(`The time is ${now.toLocaleTimeString('en-US', {
        hour12: true, hour: 'numeric', minute: 'numeric'
    })}`, width));
    
    if (arg.includes("--local")) {
        const port = config.port || 3000;
        console.log(centerText(`Site available at: http://localhost:${port}`, width));
    } else {
        console.log(centerText('The site has been exported.', width));
    }

    console.log(centerText(`##########################################`, width));
    console.log(centerText(`Made by Dalk21`, width));
    console.log(centerText(`##########################################`, width));

    logBuffer.push(`-- STARTED DEBUGGING AT ${now.toLocaleString()} --`);
}

async function debug(message) {
    //const thisConfig = await readFile("config.json");
   // if (thisConfig.debugger) {
        const logMessage = `WIST Debugger | ${new Date().toLocaleString()} | ${message}`;
        process.stdout.write(`[Debug] ${logMessage}\n`);
        logBuffer.push(logMessage);
        return true;
    //}
    return false;
}

module.exports = { intro, debug };
