const wistAPIKey = "4dc77e24801e8d21ea9ef72a9506ba0f";
const fs = require("fs");
const path = require("path");
const lib = require("../../mqttlib")

const radarTypes = {
  "radar.US": {
    timestamps: `http://192.168.0.134:3000/api/i2/r/timestamps/regional?apiKey=${wistAPIKey}`,
    frames: `http://192.168.0.134:3000/api/i2/r/reg/{ts}.tiff?apiKey=${wistAPIKey}`,
    type: "Radar",
    location: "US"
  },
  "radar.AK": {
    timestamps: `http://192.168.0.134:3000/api/i2/r/timestamps/region/ak?apiKey=${wistAPIKey}`,
    frames: `http://192.168.0.134:3000/api/i2/r/region/ak/{ts}.tiff?apiKey=${wistAPIKey}`,
    type: "Radar",
    location: "AK"
  },
  "radar.HI": {
    timestamps: `http://192.168.0.134:3000/api/i2/r/timestamps/region/hi?apiKey=${wistAPIKey}`,
    frames: `http://192.168.0.134:3000/api/i2/r/region/hi/{ts}.tiff?apiKey=${wistAPIKey}`,
    type: "Radar",
    location: "HI"
  },
  "radar.PR": {
    timestamps: `http://192.168.0.134:3000/api/i2/r/timestamps/region/pr?apiKey=${wistAPIKey}`,
    frames: `http://192.168.0.134:3000/api/i2/r/region/pr/{ts}.tiff?apiKey=${wistAPIKey}`,
    type: "Radar",
    location: "PR"
  },
  "satrad.US": {
    timestamps: `http://192.168.0.134:3000/api/i2/r/timestamps/satrad?apiKey=${wistAPIKey}`,
    frames: `http://192.168.0.134:3000/api/i2/r/satrad/{ts}.tiff?apiKey=${wistAPIKey}`,
    type: "SatRad",
    location: "US"
  }
};

async function getRadarAndSend() {
    await lib.connect()
  for (const type in radarTypes) {
    const radarType = radarTypes[type];
    const timestampsReq = await fetch(radarType.timestamps);
    if (!timestampsReq.ok) {
      console.error(`Failed to fetch timestamps for ${type}:`, timestampsReq.statusText);
      continue;
    }

    const timestamps = await timestampsReq.json();

    for (const ts of timestamps) {
      const frameUrl = radarType.frames.replace("{ts}", ts);
      //console.log(`Fetching frame: ${frameUrl}`);

      const frameResp = await fetch(frameUrl);
      if (!frameResp.ok) {
        console.error(`Failed to fetch frame ${ts}:`, frameResp.statusText);
        continue;
      }

      const buffer = await frameResp.arrayBuffer();
      const outputPath = path.join(__dirname, "temp", `${type.replace(".", "_")}_${ts}.tiff`);

      // Ensure directory exists
      fs.mkdirSync(path.dirname(outputPath), { recursive: true });

      fs.writeFileSync(outputPath, Buffer.from(buffer));
    await lib.sendI2Radar(type.split(".")[1], outputPath, ts + ".tiff", radarType.type, ts)
    fs.rmSync(outputPath)
      //console.log(`Saved frame to ${outputPath}`);

    }



  }
}

module.exports = getRadarAndSend
