const schema = require("../../../schemas");

const TWC_API_KEY = "e1f10a1e78da46f5b10a1e78da96f525";
const mqtt = require("../../mqttlib")

async function getData(locations) {
    let fullData = ``;

    for (const loc of locations) {
        const res = await getCoop(loc)
        //fullData += res;
        const fileName = `${loc}-hrly.py`
        mqtt.i1_exec(res, `runomni /twc/util/loadSCMTconfig.pyc /home/dgadmin/${fileName}`, fileName, "i1/data")
    }

    return true;
}

async function getCoop(coopId) {
    const data = await schema.i1_lfrecord("coop", coopId);
    const hourlyFetch = await fetch(
        `https://api.weather.com/v3/wx/forecast/hourly/3day?geocode=${data.lat},${data.long}&format=json&units=e&language=en-US&apiKey=${TWC_API_KEY}`,
        { timeout: 50 * 1000 }
    );

    if (!hourlyFetch.ok) return { error: "Getting hourly fcst was NOT OK" };

    const hourlyData = await hourlyFetch.json();
    hourlyData.county = data.cntyId;
    hourlyData.location = data.coopId;

    const i1_hourlyFcst = schema.i1_hourlyFcst(hourlyData);
    console.log(i1_hourlyFcst)
    return i1_hourlyFcst;
}

module.exports = getData;