const schema = require("../../../schemas");

const TWC_API_KEY = "e1f10a1e78da46f5b10a1e78da96f525";
const mqtt = require("../../mqttlib")

async function getData(locations) {
    let fullData = ``;

    for (const loc of locations) {
        const res = await getCoop(loc)
        //fullData += res;
        const fileName = `${loc}-dailyfcst.py`
        mqtt.i1_exec(res, `runomni /twc/util/loadSCMTconfig.pyc /home/dgadmin/${fileName}`, fileName, "i1/data")
    }

    return true;
}

async function getCoop(coopId) {
    const data = await schema.i1_lfrecord("coop", coopId);
    const dailyFetch = await fetch(
        `https://api.weather.com/v1/geocode/${data.lat}/${data.long}/forecast/daily/7day.json?units=e&language=en-US&apiKey=${TWC_API_KEY}`,
        { timeout: 50 * 1000 }
    );

    if (!dailyFetch.ok) return { error: "Getting daily fcst was NOT OK" };

    const dailyData = await dailyFetch.json();
    dailyData.county = data.cntyId;
    dailyData.location = data.coopId;

    const i1_dailyFcst = schema.i1_dailyFcst(dailyData);
    console.log(i1_dailyFcst)
    return i1_dailyFcst;
}

module.exports = getData;