const schema = require("../../../schemas");

const TWC_API_KEY = "e1f10a1e78da46f5b10a1e78da96f525";
const mqtt = require("../../mqttlib")

async function getData(locations) {
    let fullData = ``;

    for (const loc of locations) {
        console.log(locations)
        let res;
        if (loc.startsWith("K") || loc.startsWith("W")) {
            res = await getObs(loc);
        } else {
            res = await getTecci(loc);
        }
        const fileName = `${loc}-cc.py`
        mqtt.i1_exec(res, `runomni /twc/util/loadSCMTconfig.pyc /home/dgadmin/${fileName}`, fileName, "i1/data")
    }

    return true;
}

async function getTecci(primTecci) {
    const data = await schema.i1_lfrecord("tecci", primTecci);
    const ccFetch = await fetch(
        `https://api.weather.com/v3/wx/observations/current?geocode=${data.lat},${data.long}&units=e&language=en-US&format=json&apiKey=${TWC_API_KEY}`,
        { timeout: 50 * 1000 }
    );

    if (!ccFetch.ok) return { error: "Getting current conditions was NOT OK" };

    const ccData = await ccFetch.json();
    ccData.county = data.cntyId;
    ccData.location = data.primTecci;

    const i1_cc = schema.i1_cc(ccData);
    return i1_cc;
}

async function getObs(obsStation) {
    let data = await schema.i1_lfrecord("locId_raw", obsStation);
    console.log(data, String(JSON.stringify(data)).length);

    if (String(JSON.stringify(data)).length < 5) {
        console.log("[!] Using fallback location fetch for", obsStation);
        const locationFetch = await fetch(
            `https://api.weather.com/v3/location/point?locid=${obsStation}:2:US&language=en-US&format=json&apiKey=${TWC_API_KEY}`
        );
        if (!locationFetch.ok) return { error: "Getting location from non LFRecord was NOT OK" };

        const locationData = await locationFetch.json();
        data = {
            cntyId: locationData.location.countyId,
            lat: locationData.location.latitude,
            long: locationData.location.longitude,
            locId: obsStation
        };
    }

    const ccFetch = await fetch(
        `https://api.weather.com/v3/wx/observations/current?geocode=${data.lat},${data.long}&units=e&language=en-US&format=json&apiKey=${TWC_API_KEY}`,
        { timeout: 50 * 1000 }
    );
    if (!ccFetch.ok) return { error: "Getting current conditions was NOT OK" };

    const ccData = await ccFetch.json();
    ccData.county = data.cntyId;
    ccData.location = data.locId;

    const i1_cc = schema.i1_cc(ccData);

    return i1_cc;
}

module.exports = getData;