const schema = require("../../../schemas");
const mqtt = require("../../mqttlib")

const TWC_API_KEY = "e1f10a1e78da46f5b10a1e78da96f525";

async function getAlerts() {
    const alertsFetch = await fetch(
        `https://api.weather.com/v3/alerts/headlines?countryCode=US&format=json&language=en-US&apiKey=${TWC_API_KEY}`,
        { timeout: 50 * 1000 }
    );

    if (!alertsFetch.ok) return { error: "Getting alerts was NOT OK" };

    const alertsData = await alertsFetch.json();
    alertsData.alerts.forEach(async alert => {
        if(!(alert.significance == "W")) {
            try {
                const alertData = schema.i1_headline(alert);
                const fileName = `${alert.detailKey}.py`
                mqtt.i1_exec(alertData, `runomni /twc/util/loadSCMTconfig.pyc /home/dgadmin/${fileName}`, fileName, "i1/data")
                setTimeout(() => {
                    mqtt.i1_exec(null, `rm /home/dgadmin/${fileName}`, null, "i1/data")
                }, 30 * 1000);
            } catch {
                console.log("error getting headline")
            }
        } else {
            try {
                const alertData = await fetch(`https://api.weather.com/v3/alerts/detail?format=json&language=en-US&apiKey=${TWC_API_KEY}&alertId=${alert.detailKey}`)
                const thisAlert = await alertData.json()
                const alertI1 = schema.i1_bulletin(thisAlert.alertDetail)
                const fileName = `${alert.detailKey}.py`
                mqtt.i1_exec(alertI1, `runomni /twc/util/loadSCMTconfig.pyc /home/dgadmin/${fileName}`, fileName, "i1/data")
                setTimeout(() => {
                    mqtt.i1_exec(null, `rm /home/dgadmin/${fileName}`, null, "i1/data")
                }, 30 * 1000);
            } catch {
                console.log("error getting alert")
            }
        }
    })
    return true;
}

getAlerts()
module.exports = getAlerts;