const API_KEY = "uDCw3K3dktz0XAIymLK5uqvAGJgj2PTS";
const schema = require("../../../schemas")
const mqtt = require("../../mqttlib")


function iataFromIcao(icao) {
  if (icao.length === 4 && icao.startsWith("K")) return icao.substring(1);
  return icao;
}

async function fetchAirportDelaysXML() {
  const response = await fetch("https://aeroapi.flightaware.com/aeroapi/airports/delays", {
    headers: { "x-apikey": API_KEY }, timeout: 50000
  });
if (!response.ok) {
    throw new Error(`FlightAware API error: ${response.status} ${response.statusText}`);
  }

  const data = await response.json();

  (data.delays || []).forEach(delay => {
    if(delay.airport.startsWith("K") || delay.airport.startsWith("W")) {
        delay.airport = iataFromIcao(delay.airport)
        const data_final = schema.i1_airport(delay)
        const fileName = `${delay.airport}-AirportDelays.py`
        mqtt.i1_exec(data_final, `runomni /twc/util/loadSCMTconfig.pyc /home/dgadmin/${fileName}`, fileName, "i1/data")
    }
  })
  return true
}
fetchAirportDelaysXML()