const express = require("express");
const path = require("path");
const config = require("./config.json");
const session = require("express-session");
const cors = require("cors");
const verifyToken = require("./auth/base/verify"); // should return true/false

const app = express();

app.use(cors());

app.use(session({
  secret: config.sessionSecret || "Rainwater_Base_Session_Secret",
  resave: false,
  saveUninitialized: true,
  cookie: { secure: false } // set true if using HTTPS
}));

app.use("/api", require("./api/base"));

// Serve dynamic directory based on auth
app.use("/", async (req, res, next) => {
  try {
    const authorized = await verifyToken(req); // true if token is valid
    const folder = authorized ? "private" : "public";
    express.static(path.join(__dirname, folder))(req, res, next);
  } catch (err) {
    console.error(err);
    res.status(500).send("Internal server error");
  }
});

module.exports = app;
