const sqlite3 = require("sqlite3").verbose();
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
const path = require("path");

const config = require("../../config.json")
const DB_PATH = path.join(__dirname, "auth.db");
const JWT_SECRET = config.sessionSecret || "Rainwater_JWT_Secret_Please_change_this_lol"; // change this in production

const db = new sqlite3.Database(DB_PATH);

function getUser(username) {
  return new Promise((resolve, reject) => {
    db.get("SELECT * FROM users WHERE username = ?", [username], (err, row) => {
      if (err) return reject(err);
      resolve(row);
    });
  });
}

async function login(username, password) {
  if (!username || !password) throw new Error("Missing username or password");

  const user = await getUser(username);
  if (!user) return "Invalid credentials";

  const match = await bcrypt.compare(password, user.password);
  if (!match) return "Invalid credentials";

  const token = jwt.sign(
    { id: user.id, username: user.username, apiKey: user.apiKey },
    JWT_SECRET,
    { expiresIn: "2h" }
  );

  return `true-${token}`;
}

module.exports = { login };
