const express = require("express")
const path = require("path")

const app = new express()
const session = require('express-session');
const config = require("../config.json")
app.use(session({
  secret: config.sessionSecret || "Rainwater_Base_Session_Secret",
  resave: false,
  saveUninitialized: true,
  cookie: { secure: false } // Set to true if using HTTPS
}));
const isAuthenticated = require("../auth/exp-verify")
const bodyParser = require("body-parser")


app.use("/wx", require("./weather/base"))
app.use("/maps", require("./images/radar").app)
app.use("/weather", require("./weather/base"))
app.use(bodyParser.json())

app.post("/login", async (req, res) => {
    if(!req.body) return res.status(200).send("Please send a body")
    if(!req.body.username) return res.status(200).send("Please send a username")
    if(!req.body.password) return res.status(200).send("Please send a password")
    const login = await require("../auth/base/auth-signin").login(req.body.username, req.body.password)
    if(login.startsWith("true-")) {
        req.session.token = login.split("true-")[1]
        return res.send("OK")//res.json({token: login.split("true-")[1]})
    } else {
        return res.status(400).send("Invalid credentials")
    }
})

app.get("/", isAuthenticated, (req, res) => {
    res.send("hi the API is working")
})

module.exports = app