const loginForm = document.getElementById('loginForm');
const responseMessage = document.getElementById('responseMessage');

loginForm.addEventListener('submit', async function(e) {
    e.preventDefault();

    const username = document.getElementById('username').value;
    const password = document.getElementById('password').value;

    const payload = {
        username: username,
        password: password
    };

    try {
        const response = await fetch('/api/login', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(payload)
        });

        if (response.status === 200) {
            responseMessage.textContent = 'Logged in successfully (redirecting)';
            responseMessage.classList.add('success');
            responseMessage.classList.remove('error');

            setTimeout(() => {
                window.location.href = '/';
            }, 1000);
        } else if (response.status === 400) {
            responseMessage.textContent = 'Invalid username or password';
            responseMessage.classList.add('error');
            responseMessage.classList.remove('success');
        } else {
            responseMessage.textContent = 'An unexpected error occurred';
            responseMessage.classList.add('error');
            responseMessage.classList.remove('success');
        }
    } catch (error) {
        responseMessage.textContent = 'An error occurred while trying to login';
        responseMessage.classList.add('error');
        responseMessage.classList.remove('success');
    }
});