// Holidays.js
const fs = require("fs");
const path = require("path");
const zipLib = require("zip-lib");
const { exec, publishAsync } = require("../../mqttlib");
const schemaSys = require("../../../schemas")

const tempDir = path.join(__dirname, "temp2");
if (!fs.existsSync(tempDir)) fs.mkdirSync(tempDir);
const { v4: uuidv4 } = require('uuid');

const generateTempFileName = () => uuidv4();

const generateXML = (fileActions, type, starflag) => {
  const now = new Date();
  const formattedDate = `${String(now.getMonth() + 1).padStart(2, 0)}/${String(now.getDate()).padStart(2, 0)}/${now.getFullYear()}`;


  let xmlContent = `
<StarBundle>
  <Version>${638764964506688900 + (new Date() / 1)}</Version>
  <ApplyDate>${formattedDate}</ApplyDate>
  <Type>${type}</Type>
  <FileActions>
`;
    const data= {HeadendIds:["1","2"],version:638764964506688900 + (new Date() / 1)}

      let currentVersion = Number(data.version);

  fileActions.forEach(({ src, dest }) => {
    currentVersion += 1000;
    const cleanedDest = dest.replaceAll("SD_", "").replaceAll("/", "\\");
    data.HeadendIds.forEach(() => {
      const platform = "Domestic_Universe";
      xmlContent += `    <Add src="${src}" dest="${cleanedDest}" version="${currentVersion}" starFlags="${starflag}" />\n`;
      //xmlContent += `    <Add src="${src}" dest="${cleanedDest}" version="${currentVersion}" />\n`;
    });
  });

  data.version = currentVersion;

  xmlContent += `  </FileActions>
</StarBundle>`;

  return xmlContent;
};

async function generateHolidayBundles() {
  const hdXml = schemaSys.i2_res_holidays("hd")
  const sdXml = schemaSys.i2_res_holidays("sd");
  
    await createAndSendBundle(
    "Domestic_Universe",
    hdXml,
    "holidays_hd.xml",
    "Mapping/HolidayMapping.xml",
    "Managed",
    "i2/data"
  );

  await createAndSendBundle(
    "Domestic_SD_Universe",
    sdXml,
    "holidays_sd.xml",
    "Mapping/HolidayMapping.xml",
    "Managed",
    "i2/data"
  );
}

async function createAndSendBundle(starType, fileData, fileName, destPath, bundleType, topic) {
  await exec("resetAllStarBundleVersions(BType=Managed)", topic);
    const filePath = path.join(tempDir, fileName)
    fs.writeFileSync(filePath, fileData)
  const fileActions = [{ src: path.basename(filePath), dest: destPath, ogFileName: fileName }];
  const manifestXML = generateXML(fileActions, bundleType, starType);
  
  const metadataDir = path.join(tempDir, "MetaData");
  if (!fs.existsSync(metadataDir)) fs.mkdirSync(metadataDir);
  fs.writeFileSync(path.join(metadataDir, "manifest.xml"), manifestXML, "utf8");

  const zip = new zipLib.Zip();
  zip.addFile(filePath);
  zip.addFile(path.join(metadataDir, "manifest.xml"), "MetaData\\manifest.xml");

  const zipName = `H_${Math.floor(Math.random() * 100000000000)}_${bundleType}_StarBundle.zip`;
  const zipPath = path.join(tempDir, zipName);
  await zip.archive(zipPath);
  console.log(zipPath)

  const fileBuffer = fs.readFileSync(zipPath);
  const base64Data = fileBuffer.toString("base64");

  const message = JSON.stringify({
    fileName: zipName,
    data: base64Data,
    workRequest: `stageStarBundle(File={filepath})`,
    payloadType: "i2StarBundle"
  });

  await publishAsync(topic, message);
  console.log(`📦 ${bundleType} bundle sent as ${zipName}`);

  // Cleanup
  //fs.unlinkSync(zipPath);
  fs.unlinkSync(path.join(metadataDir, "manifest.xml"));
}

// Export
module.exports = generateHolidayBundles;