const schema = require("../../../schemas");

const TWC_API_KEY = "e1f10a1e78da46f5b10a1e78da96f525";
const mqtt = require("../../mqttlib")

async function getData(locations) {
    let fullData = ``;

    for (const loc of locations) {
       //console.log(locations)
        const res = await getSki(loc);
        const fileName = `${loc}-ski.py`
        await mqtt.i1_exec(res, `runomni /twc/util/loadSCMTconfig.pyc /home/dgadmin/${fileName}`, fileName, "i1/data/ski")
        mqtt.disconnect()
    }

    return true;
}

async function getSki(skiId) {
    const ccFetch = await fetch(
        `https://api.onthesnow.com/api/v2/resort/${skiId}/snowreport`,
        { timeout: 50 * 1000 }
    );

    if (!ccFetch.ok) return { error: "Getting ski conditions was NOT OK" };

    const ccData = await ccFetch.json();
    ccData.location = skiId;

    const i1_cc = schema.i1_res_ski(ccData);
    return i1_cc;
}

module.exports = getData;