const lib = require("../../mqttlib");
const schemas = require("../../../schemas");

const radarTypes = {
  "snowfallQpfForecast.US": {
    type: "snowfallQpfForecast",
    location: "US",
    dir: "/twc/data/volatile/images/snowfallQpfForecast",
    fileName: "{ts}.{ts+12}.1.1.tif"
  },
};

async function getRadarAndSend() {
  await lib.connect()
  for (const type in radarTypes) {
    const radarType = radarTypes[type];
    let mapData = schemas.images_maps_data()
    for (const key in mapData) {
      if(mapData[key]?.starName == type) {
        mapData = mapData[key]
      }
    }
    const timestampsReq = schemas.images_maps_content()

    const timestamps = timestampsReq[mapData.apiName] || []
    for (const ts of timestamps) {
     //console.log(ts.split(".tiff")[0].split("/").reverse()[0] + ".tif")
      const formattedFileName = radarType.fileName.replace("{ts}", ts.split(".tiff")[0].split("/").reverse()[0]).replace("{ts+12}", Number(ts.split(".tiff")[0].split("/").reverse()[0]) + (12 * 60 * 60))
     //console.log(`i1/${radarType.type}`, radarType.dir, formattedFileName, radarType.type.replace("satrad", "radarSatellite"), radarType.location, ts)
      await lib.sendI1Map(`i1/${radarType.type}`, radarType.dir, formattedFileName, radarType.type.replace("satrad", "radarSatellite"), radarType.location, ts)
    }
    ///twc/data/volatile/images/snowfallQpfForecast/us/1340957580.1340997180.1.1.tif
    setTimeout(() => {
      lib.disconnect()
    }, 30 * 1000);
  }
}

getRadarAndSend()
setInterval(() => getRadarAndSend(), 5 * 60 * 1000)
module.exports = getRadarAndSend