const path = require("path");
const fs = require("fs");

const dataTypes = [
  { name: "CurrentObservations", module: require("./cc"), locations: "obs" },
  { name: "HourlyForecast", module: require("./hourlyFcst"), locations: "coop" },
  { name: "DaypartForecast", module: require("./daypart"), locations: "coop" },
  { name: "DailyForecast", module: require("./dailyFcst"), locations: "coop" },
];

let slicerCode = null;
let slicerTimer = null;
let refreshTimer = null;

async function sendSlicer() {
  try {
    if (!slicerCode) {
      slicerCode = fs.readFileSync(path.join(__dirname, "i1RadarSlicer.py"), "utf-8");
    }
    const lib = require("../../mqttlib");
    await lib.i1_exec(slicerCode, "python i1RadarSlicer.py", "i1RadarSlicer.py", "i1/radar");
  } catch (e) {
    console.error("[slicer] Error:", e.message);
  }
}

async function fetchDataForType(type) {
  const locations = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../../locations.json")))
  try {
    return await type.module(locations.i1[type.locations]);
  } catch (err) {
    console.error(`[-] Fetch failed for ${type.name}:`, err.message);
    return null;
  }
}

async function start() {
  for (const type of dataTypes) {
    await fetchDataForType(type);
  }

  await sendSlicer();

  if (slicerTimer) clearInterval(slicerTimer);
  if (refreshTimer) clearInterval(refreshTimer);

  slicerTimer = setInterval(sendSlicer, 5 * 60 * 1000);
  refreshTimer = setInterval(async () => {
    try {
      for (const type of dataTypes) {
        await fetchDataForType(type);
      }
      const lib = require("../../mqttlib");
      await lib.heartbeat?.();
    } catch (err) {
      console.error("[scheduler] Error:", err.message);
    }
  }, 60 * 1000);
}

start();

module.exports = start;