const schema = require("../../../schemas");

const TWC_API_KEY = "e1f10a1e78da46f5b10a1e78da96f525";
const mqtt = require("../../mqttlib")

async function getData(locations) {
    let fullData = ``;

    for (const loc of locations) {
        const res = await getCoop(loc)
        //fullData += res;
        const fileName = `${loc}-dailyfcst.py`
        await mqtt.i1_exec(res, `runomni /twc/util/loadSCMTconfig.pyc /home/dgadmin/${fileName}`, fileName, "i1/data/daily")
        mqtt.disconnect()
    }

    return true;
}

async function getCoop(coopId) {
    const data = await schema.istar_lfrecord("coop", coopId);
    const dailyFetch = await fetch(
        `https://api.weather.com/v1/geocode/${data.lat}/${data.long}/forecast/daily/7day.json?units=e&language=en-US&apiKey=${TWC_API_KEY}`,
        { timeout: 50 * 1000 }
    );

    if (!dailyFetch.ok) return { error: "Getting daily fcst was NOT OK" };

    const dailyData = await dailyFetch.json();
    dailyData.county = data.cntyId;
    dailyData.location = data.coopId;

    const i1_dailyFcst = schema.i1_res_dailyFcst(dailyData);
    //console.log(i1_dailyFcst)
    return i1_dailyFcst;
}
//getData(['72658010','06240000','07149000','16242000','45007000','47671000','71182000','71624000','71627001','71852000','71879001','71892000','71892001','71913000','71936000','71966000','72205000','72219000','72259000','72295023','72315090','72330002','72334001','72340004','72344000','72344051','72348022','72348039','72348050','72349031','72356000','72405000','72435000','72440000','72440034','72440048','72440054','72440066','72494000','72503023','72509000','72530000','76255000','76393000','76405000','76595000','76679001','78073000','87576000','94767000',])

module.exports = getData;