const {
    REST
} = require('@discordjs/rest'); // Get discord's REST API
const {
    Routes
} = require('discord-api-types/v9'); // Get Discord API
const config = require('./config.json'); // Get our Configuration file
const {
    Client,
    GatewayIntentBits
} = require('discord.js'); // Get discord.js

const client = new Client({
    intents: [
        GatewayIntentBits.Guilds,
    ]
}); // Create a new client
client.login(require("../../config.json").encoderToken); // Login to that client
const rest = new REST({
    version: '9'
}).setToken(require("../../config.json").encoderToken); // Create a new REST endpoint

const commands = [ // Commands list
    {
        contexts: [0, 1, 2],
        integration_types: [0, 1],
        dm_permission: true,
        name: 'register', // Name of the command
        description: 'Register a new I2 unit to Rainwater!', // Description of the command
        options: [{
            name: 'unit-type', // Name of the option
            description: 'What type of unit do you want?', // Description of the option
            type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
            required: true, // Is the option required?
            choices: [{
                    name: 'xD',
                    value: 'xd'
                },
                {
                    name: 'Jr',
                    value: 'jr'
                },
            ]
        }, {
            name: 'nickname', // Name of the option
            description: 'Set a nickname for the unit!', // Description of the option
            type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
            required: false
        }]
    },
    {
        contexts: [0, 1, 2],
        integration_types: [0, 1],
        dm_permission: true,
        name: 'restart',
        description: 'Restarts a part of I2 on a star system.',
        options: [{
                name: 'process',
                description: 'Restarts an I2 process',
                type: 1, // Subcommand
                options: [{
                        name: 'star',
                        description: 'The star ID to run it on. (You must have access)',
                        type: 3, // STRING
                        required: true,
                        autocomplete: true

                    },
                    {
                        name: 'process',
                        description: 'The FULL name of the I2 process. Eg, I2jPipeline',
                        type: 3, // STRING
                        required: true, // Is the option required?
                        choices: [{
                                name: 'Viz',
                                value: 'viz'
                            },
                            {
                                name: 'I2jPipeline',
                                value: 'I2jPipeline'
                            },
                            {
                                name: 'TWC.RenderController',
                                value: 'TWC.RenderController'
                            },
                            {
                                name: 'TWC.DataPump',
                                value: 'TWC.DataPump'
                            },
                            {
                                name: 'TWC.Executioner',
                                value: 'TWC.Executioner'
                            },
                            {
                                name: 'TWC.RemoteManagement',
                                value: 'TWC.RemoteManagement'
                            },
                            {
                                name: 'TWC.MsgProcessor',
                                value: 'TWC.MsgProcessor'
                            },
                            {
                                name: 'TWC.MsgIngester',
                                value: 'TWC.MsgIngester'
                            },
                        ]
                    },
                ]
            },
            {
                name: 'system',
                description: 'Restarts the entire I2 system',
                type: 1, // Subcommand
                options: [{
                    name: 'star',
                    description: 'The star ID to run it on. (You must have access)',
                    type: 3, // STRING
                    required: true,
                    autocomplete: true

                }]
            },
            {
                name: 'i2service',
                description: 'Restarts the I2 Windows service',
                type: 1, // Subcommand
                options: [{
                    name: 'star',
                    description: 'The star ID to run it on. (You must have access)',
                    type: 3, // STRING
                    required: true,
                    autocomplete: true

                }]
            }
        ]
    },
    {
        contexts: [0, 1, 2],
        integration_types: [0, 1],
        dm_permission: true,
        name: 'location-info',
        description: 'Get info on a STAR based-location.',
        options: [{
                name: 'location-id',
                description: 'Use the TWC locId for lookup',
                type: 1, // Subcommand
                options: [{
                        name: 'id',
                        description: 'The Location ID (ex. 1_US_USMN0503)',
                        type: 3, // STRING
                        required: true
                    }
                ]
            },
            {
                name: 'name',
                description: 'Use the location name for lookup',
                type: 1, // Subcommand
                options: [{
                        name: 'city',
                        description: 'The city (ex. Minneapolis)',
                        type: 3, // STRING
                        required: true
                    },
                    {
                        name: 'state',
                        description: 'The state abbreviation (ex. MN)',
                        type: 3, // STRING
                        required: true
                    }
                ]
            }
        ]
    },
    {
        contexts: [0, 1, 2],
        integration_types: [0, 1],
        dm_permission: true,
        name: 'auth',
        description: 'Manage authentication on your STAR.',
        options: [{
                name: 'add',
                description: 'Add a user to have access',
                type: 1, // Subcommand
                options: [{
                        name: 'star',
                        description: 'The star ID to run it on. (You must have access)',
                        type: 3, // STRING
                        required: true,
                        autocomplete: true

                    },
                    {
                        name: 'permissions',
                        description: 'Permissions to grant (must be comma seperated, eg. cues,management or management, or cues).',
                        type: 3, // STRING
                        required: true,
                    },
                    {
                        name: 'user',
                        description: 'Who do you want to give access to?',
                        type: 6, // STRING
                        required: true,
                    },
                ]
            },
            {
                name: 'remove',
                description: 'Remove a user\'s access to your I2',
                type: 1, // Subcommand
                options: [{
                        name: 'star',
                        description: 'The star ID to run it on. (You must have access)',
                        type: 3, // STRING
                        required: true,
                        autocomplete: true

                    },
                    {
                        name: 'user',
                        description: 'Who do you want to remove access from?',
                        type: 6, // STRING
                        required: true,
                    },
                ]
            },
            {
                name: 'delete',
                description: 'Remove your I2 from the database',
                type: 1, // Subcommand
                options: [{
                    name: 'star',
                    description: 'The star ID to run it on. (You must have access)',
                    type: 3, // STRING
                    required: true,
                    autocomplete: true
                }]
            }
        ]
    },
    {
        contexts: [0, 1, 2],
        dm_permission: true,
        integration_types: [0, 1],
        name: 'cuer',
        description: 'Handle cueing tasks (similar to 45D/I2-Heartbeat)',
        options: [{
                name: 'toggle',
                description: 'Toggle on/off automatic cues',
                type: 1, // Subcommand
                options: [{
                    name: 'star',
                    description: 'The star ID to run it on. (You must have access)',
                    type: 3, // STRING
                    required: true,
                    autocomplete: true

                }]
            },
            {
                name: 'configure',
                description: 'Configure your cueing',
                type: 1, // Subcommand
                options: [{
                        name: 'star',
                        description: 'The star ID to run it on. (You must have access)',
                        type: 3, // STRING
                        required: true,
                        autocomplete: true
                    },
                    {
                        name: 'flavor',
                        description: 'The flavor to change it to',
                        type: 3, // STRING
                        required: false,
                        autocomplete: true
                    },
                    {
                        name: 'timing',
                        description: 'Timing (format: EVERY/ONTHE, ex. 10/8 for every 10 mins on 8, 30/18 for :18 and :48',
                        type: 3, // STRING
                        required: false,
                    },
                    {
                        name: 'duration',
                        description: 'The duration in frames (seconds * 30)',
                        type: 4, // STRING
                        required: false,
                    },
                    {
                        name: 'enabled',
                        description: 'Enable or disable automatic cueing',
                        type: 5, // STRING
                        required: false,
                    },
                    {
                        name: 'ldl',
                        description: 'The flavor for the LDL',
                        type: 3, // STRING
                        required: false,
                        autocomplete: true
                    },
                    {
                        name: 'sidebar',
                        description: 'Sidebar flavor (set to "None" to disable)',
                        type: 3, // STRING
                        required: false,
                        autocomplete: true
                    },
                    {
                        name: 'background',
                        description: 'LOT8s Background (0 for generic, 9 for random)',
                        type: 3, // STRING
                        required: false,
                autocomplete: true
                    }
                ]
            },
            {
                name: 'force',
                description: 'Force an I2 Cue.',
                type: 1,
                options: [{
                    name: 'star',
                    description: 'The star ID to run it on. (You must have access)',
                    type: 3, // STRING
                    required: true,
                    autocomplete: true
                }]
            },
            {
        name: 'manual', // Name of the command
                type: 1, // Subcommand
        description: 'Manually choose heartbeat options to run a playlist with!', // Description of the command
        options: [{
                name: 'star', // Name of the option
                description: 'The star ID to run it on. (You must have access)', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true,
                autocomplete: true
            },
            {
                name: 'flavor', // Name of the option
                description: 'The flavor to run. Must include domestic/', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true,
                        autocomplete: true
            },
            {
                name: 'duration', // Name of the option
                description: 'The duration in frames (seconds * 30)', // Description of the option
                type: 4, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true
            },
            {
                name: 'background', // Name of the option
                description: 'The background for the cue (eg. domesticAds/TAG3093)', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: false,
                autocomplete: true
            },
        ]}
        ]
    },
    {
        contexts: [0, 1, 2],
        dm_permission: true,
        integration_types: [0, 1],
        name: 'playlist',
        description: 'I2 Playlist management tools',
        options: [
            {
                name: 'cancel',
                description: 'Cancel a playlist.',
                type: 1,
                options: [{
                    name: 'star',
                    description: 'The star ID to run it on. (You must have access)',
                    type: 3, // STRING
                    required: true,
                    autocomplete: true
                },
            {
                    name: 'presentation-id',
                    description: 'The presentation ID to cancel (ex. ldl3, sidebar2, 4)',
                    type: 3, // STRING
                    required: true,
                    autocomplete: true
                }]
            },
            {
        name: 'loadrun', // Name of the command
                type: 1, // Subcommand
        description: 'Manually load & run a playlist.', // Description of the command
        options: [{
                name: 'star', // Name of the option
                description: 'The star ID to run it on. (You must have access)', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true,
                autocomplete: true
            },
            {
                name: 'flavor', // Name of the option
                description: 'The flavor to run. Must include domestic/', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true,
                        autocomplete: true
            },
            {
                name: 'duration', // Name of the option
                description: 'The duration in frames (seconds * 30)', // Description of the option
                type: 4, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true
            },
            {
                name: 'background', // Name of the option
                description: 'The background for the cue (eg. domesticAds/TAG3093)', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: false,
                autocomplete: true
            },
        ]}
        ]
    },
    {
        contexts: [0, 1, 2],
        dm_permission: true,
        integration_types: [0, 1],
        name: 'fake-alert', // Name of the command
        description: 'Loads & runs an I2 playlist!', // Description of the command
        options: [{
                name: 'star', // Name of the option
                description: 'The star ID to run it on. (You must have access)', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true,
                autocomplete: true
            },
            {
                name: 'expiration', // Name of the option
                description: 'When to expire?', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true
            },
            {
                name: 'name', // Name of the option
                description: 'What is the name of the alert (eg. TORNADO WARNING)', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true
            },
            {
                name: 'bulletin', // Name of the option
                description: 'What is the bulletin text of the alert (eg. TORNADO WARNING IN EFFECT)', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true
            },
                        {
                name: 'type', // Name of the option
                description: 'The type of alert, ex. WS_W or TO_W, or GENERIC. Must be uppercase.', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: false,
            },
        ]
    },
    {
        contexts: [0, 1, 2],
        dm_permission: true,
        integration_types: [0, 1],
        name: 'change-config', // Name of the command
        description: 'Change the MachineProduct Config on your I2!', // Description of the command
        options: [{
                name: 'star', // Name of the option
                description: 'The star ID to run it on. (You must have access)', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true,
                autocomplete: true
            },
            {
                name: 'config', // Name of the option
                description: 'What config (use autocomplete)?', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true,
                autocomplete: true
            }
        ]
    },
    {
        contexts: [0, 1, 2],
        dm_permission: true,
        integration_types: [0, 1],
        name: 'exec', // Name of the command
        description: 'Run a I2 Exec command!', // Description of the command
        options: [{
                name: 'star', // Name of the option
                description: 'The star ID to run it on. (You must have access)', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true,
                autocomplete: true
            },
            {
                name: 'command', // Name of the option
                description: 'What command? You must know it.', // Description of the option
                type: 3, // Type of option (Read: https://discord.com/developers/docs/interactions/application-commands#application-command-object-application-command-option-type)
                required: true,
                //autocomplete: true
            }
        ]
    }
]

// Register the commands globally for your application
client.on('ready', () => { // When we sign into the bot
    (async () => {
        try {
            console.log('Started refreshing application (/) commands.'); // Refresh commands

            await rest.put( // Actually refresh them
                Routes.applicationCommands(client.user.id), // Send the commands
                {
                    body: commands
                }, // The commands
            );

               await rest.put(
                 Routes.applicationGuildCommands(client.user.id, "1330726155686379561"),
                 {body: commands}
               )

            console.log('Successfully reloaded application (/) commands.'); // Completed refreshing commands
        } catch (error) {
            console.error(error); // Log errors
        }
    })();
});