// Run "npm i"

// Introduce the main components for our bot
const {
    Client,
    GatewayIntentBits,
    ActivityType,
    EmbedBuilder,
    Message,
    Events,
    AttachmentBuilder,
    Embed,
    WebhookClient
} = require('discord.js') // Gets the latest version of discord.js (for this tutorial, it is v14.8.0)
const config = {activity:"the stars..."}; // Get the configuration file
const client = new Client({ // Create the client
    intents: [ // List our intents for the discord bot. Read this: https://discord.com/developers/docs/topics/gateway#list-of-intents
    ]
})
const webhook = new WebhookClient({url:require("../../config.json").webhook})
const getApiKey = require("../../auth/base/encoder")

// What do we do when the bot is online?
client.on('ready', () => {
    console.log('[bot] ready'); // Notifys the user of the bot being online
    client.user.setActivity(config.activity, {
        type: ActivityType.Watching
    }); // Sets the activity of the bot 
    webhook.send({content:"SoftServe is now online."})
});

const fs = require("fs");
const path = require('path');

function checkAccess(data, userId, action) {
    if (data.owner == userId) return true;
    if (data.access[userId]) {
        if (data.access[userId].includes(action)) {
            return true
        } else return false;
    } else {
        return false
    };
}

// ===== LOAD/SAVE usersData SHARED =====
const userstarsPath = path.join(__dirname, "userstars.json");
let usersData = {};
try {
    const data = fs.readFileSync(userstarsPath, "utf-8")
    usersData = JSON.parse(data);
} catch (e) {
    console.error("Failed to load userstars.json:", e);
}

async function saveUsersData(data) {
    try {
        usersData = (data || usersData)
        await fs.promises.writeFile(userstarsPath, JSON.stringify((data || usersData), null, 2));
        console.log("✅ userstars.json saved");
    } catch (e) {
        console.error("❌ Failed to save userstars.json:", e);
    }
}

function checkAccess(data, userId, action) {
    if (data.owner == userId) return true;
    if (data.access[userId]) {
        return data.access[userId].includes(action);
    }
    return false;
}

const mqttlib = require("../mqttlib");
const {
    default: mqtt
} = require('mqtt');

function parseRelativeTime(input) {
  if (!input) return null;

  const timeUnits = {
    second: 1000,
    seconds: 1000,
    sec: 1000,
    secs: 1000,
    s: 1000,

    minute: 60 * 1000,
    minutes: 60 * 1000,
    min: 60 * 1000,
    mins: 60 * 1000,
    m: 60 * 1000,

    hour: 60 * 60 * 1000,
    hours: 60 * 60 * 1000,
    hr: 60 * 60 * 1000,
    hrs: 60 * 60 * 1000,
    h: 60 * 60 * 1000,

    day: 24 * 60 * 60 * 1000,
    days: 24 * 60 * 60 * 1000,
    d: 24 * 60 * 60 * 1000,
  };

  const regex = /(\d+\.?\d*)\s*(\w+)/i;
  const match = input.trim().toLowerCase().match(regex);

  if (!match) return null;

  const value = parseFloat(match[1]);
  const unit = match[2];

  for (const [key, multiplier] of Object.entries(timeUnits)) {
    if (unit.startsWith(key)) {
      return value * multiplier;
    }
  }

  return null;
}


async function logMsg(interactor, interactStar, action) {
    let stars, cues;
    try {
        stars = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf8"));
    } catch (e) {
        console.error("Failed to read userstars.json:", e);
        stars = {};
    }

    try {
        cues = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf8"));
    } catch (e) {
        console.error("Failed to read cues.json:", e);
        cues = {};
    }

    let user, owner, ownerUser;

    try {
        user = await client.users.fetch(interactor);
    } catch (e) {
        console.error("Failed to fetch interactor user:", e);
        user = { username: "Unknown User" };
    }

    if (stars[interactStar]?.owner) {
        try {
            ownerUser = await client.users.fetch(stars[interactStar].owner);
        } catch (e) {
            console.error("Failed to fetch owner user:", e);
            ownerUser = { username: "Unknown Owner" };
        }
    }

    const parts = [
        `SoftServe:`,
        `User ${interactor} (**${user.username}**) has ${action} to STAR ${interactStar}`
    ];

    if (ownerUser && stars[interactStar]) {
        parts.push(`(${ownerUser.username}/${stars[interactStar].owner})`);
    }

    if (cues[interactStar]) {
        const unitType = String(cues[interactStar].unitType || "Unknown").toUpperCase();
        const location = cues[interactStar].location?.display || "Unknown Location";
        parts.push(`which is a ${unitType} for \`${location}\``);
    }

    try {
        await webhook.send({ content: parts.join(" ") });
    } catch (e) {
        console.error("Failed to send webhook message:", e);
    }
}

const wistApiKey = "4dc77e24801e8d21ea9ef72a9506ba0f"

// Slash command handler
client.on(Events.InteractionCreate, async (interaction) => { // When a interaction is made
    if(interaction.isCommand() && (!(interaction.commandName === 'register'))) {
        await interaction.deferReply({ephemeral:false})
    }
    if(interaction.commandName === 'register') {
        await interaction.deferReply({ephemeral:true})
    }
    const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "userstars.json"), "utf-8"));
    const starData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"));

    const permissionMap = {
        auth: {
            add: "owner",
            remove: "owner",
            delete: "owner"
        },
        playlist: {
            loadrun: "cues",
            cancel: "cues"
        },
        restart: {
            system: "owner",
            i2service: "management",
            process: "management"
        },
        cuer: {
            toggle: "cues",
            force: "cues",
            configure: "cues",
            manual: "cues"
        },
        "fake-alert": "cues",
        "change-config": "management",
        "exec": "owner"
    };

    if (interaction.isAutocomplete()) {
    const focusedOption = interaction.options.getFocused(true);
    const commandName = interaction.commandName;
    const subcommandName = interaction.options.getSubcommand(false); // doesn't throw if missing
    const userId = interaction.user.id;
    const starId = interaction.options.getString("star");
    const unitType = starId && starData[starId]?.unitType?.toLowerCase();
    const results = [];

    if (focusedOption.name === "star") {
        let requiredPermission;
        if (permissionMap[commandName]) {
            if (typeof permissionMap[commandName] === "string") {
                requiredPermission = permissionMap[commandName];
            } else if (subcommandName && permissionMap[commandName][subcommandName]) {
                requiredPermission = permissionMap[commandName][subcommandName];
            }
        }

        for (const [starId, data] of Object.entries(usersData)) {
            const isOwner = data.owner === userId;
            const userPerms = data.access?.[userId] || [];

            if (commandName === "auth" && isOwner) {
                results.push({
                    name: `Your ${starData[starId].unitType.toUpperCase()}${starData[starId].nickname ? ` - ${starData[starId].nickname} ` : " "}(${starId})`,
                    value: starId
                });
                continue;
            }

            if (requiredPermission === "owner" && isOwner) {
                results.push({
                    name: `Your ${starData[starId].unitType.toUpperCase()}${starData[starId].nickname ? ` - ${starData[starId].nickname} ` : " "}(${starId})`,
                    value: starId
                });
                continue;
            }

            if (userPerms.includes(requiredPermission) || isOwner) {
                const ownerUser = await client.users.fetch(data.owner);
                const prefix = isOwner ? "Your" : `${ownerUser.username}'s`;
                results.push({
                    name: `${prefix} ${starData[starId].unitType.toUpperCase()}${starData[starId].nickname ? ` - ${starData[starId].nickname} ` : " "}${starData[starId]?.location?.display ? ` - ${starData[starId]?.location?.display} - ` : ""}(${starId})`,
                    value: starId
                });
            }
        }
    } else if (["flavor", "ldl", "sidebar"].includes(focusedOption.name)) {
        const flavorMap = {
            flavor: {
                jr: [
                    ["Enhanced", "domestic/V"],
                    ["Nemo", "domestic/N"],
                    ["Azul", "domestic/azul i2 jr"],
                    ["Enhanced Breaking", "domestic/V1"],
                    ["Enhanced Severe", "domestic/V2"]
                ],
                xd: [
                    ["Nemo", "domestic/V"],
                    ["Enhanced", "domestic/V2016"],
                    ["Azul", "domestic/Azul"],
                    ["Nemo Breaking", "domestic/V1"],
                    ["Nemo Severe", "domestic/V2"]
                ],
                global: [
                    ["Nemo xD/Enhanced Jr", "domestic/V"],
                    ["Nemo Jr", "domestic/N"],
                    ["Enhanced xD", "domestic/V2016"],
                    ["Azul Jr", "domestic/azul i2 jr"],
                    ["Azul xD", "domestic/Azul"]
                ]
            },
            ldl: {
                jr: [
                    ["Enhanced", "domestic/ldlC"],
                    ["Nemo", "domestic/ldlE"],
                    ["Azul", "domestic/azulldl_16"],
                    ["Enhanced Breaking", "domestic/ldlD"],
                    ["Nemo Breaking", "domestic/ldlF"]
                ],
                xd: [
                    ["Enhanced", "domestic/ldlC"],
                    ["Nemo", "domestic/ldlE"],
                    ["Azul", "domestic/azulldl_16"],
                    ["Azul Large", "domestic/azulldl"],
                    ["Enhanced Breaking", "domestic/ldlD"],
                    ["Nemo Breaking", "domestic/ldlF"]
                ],
                global: [
                    ["Enhanced", "domestic/ldlC"],
                    ["Nemo", "domestic/ldlE"],
                    ["Azul", "domestic/azulldl_16"],
                    ["Azul Large", "domestic/azulldl"],
                    ["Enhanced Breaking", "domestic/ldlD"],
                    ["Nemo Breaking", "domestic/ldlF"]
                ]
            },
            sidebar: {
                jr: [
                    ["None", "none"]
                ],
                xd: [
                    ["Enhanced Sidebar (1)", "domestic/sidebarXC"],
                    ["Enhanced Sidebar (2)", "domestic/sidebarC"],
                    ["Enhanced Sidebar Breaking (1)", "domestic/sidebarXD"],
                    ["Enhanced Sidebar Breaking (2)", "domestic/sidebarD"],
                    ["Nemo Sidebar", "domestic/sidebarE"],
                    ["None", "none"]
                ],
                global: [
                    ["Enhanced Sidebar (1)", "domestic/sidebarXC"],
                    ["Enhanced Sidebar (2)", "domestic/sidebarC"],
                    ["Enhanced Sidebar Breaking (1)", "domestic/sidebarXD"],
                    ["Enhanced Sidebar Breaking (2)", "domestic/sidebarD"],
                    ["Nemo Sidebar", "domestic/sidebarE"],
                    ["None", "none"]
                ]
            }
        };

        const category = flavorMap[focusedOption.name];
        const list = unitType === "jr" ? category.jr : unitType === "xd" ? category.xd : category.global;

        const filtered = list
            .filter(([name]) => name.toLowerCase().includes(focusedOption.value.toLowerCase()))
            .map(([name, value]) => ({ name: `${name} (${value})`, value }));

        results.push(...filtered.slice(0, 25));
    } else if (focusedOption.name === "config") {
        const configs = JSON.parse(await fs.promises.readFile(path.join(__dirname, "configs.json"), "utf8"));

        const filtered = configs
            .filter(config =>
                `${config.city}, ${config.state}`.toLowerCase().includes(focusedOption.value.toLowerCase()) ||
                config.isp?.toLowerCase().includes(focusedOption.value.toLowerCase())
            )
            .map(config => ({
                name: `${config.city.toUpperCase()}, ${config.state} - ${config.isp}`,
                value: config.filePath
            }));

        results.push(...filtered.slice(0, 25));
    } else if (focusedOption.name === "background") {
        let backgroundsPath;
    
        // Try to determine path based on unitType
        if (unitType === "jr") {
            backgroundsPath = path.join(__dirname, "../jr.json");
        } else {
            backgroundsPath = path.join(__dirname, "../xd.json");
        }
    
        let backgrounds = [];
    
        try {
            backgrounds = JSON.parse(await fs.promises.readFile(backgroundsPath, "utf8"));
        } catch (e) {
            console.error(`Failed to read backgrounds file: ${backgroundsPath}`, e);
        }
    
        const filtered = backgrounds
            .filter(bg =>
                bg.Description.toLowerCase().includes(focusedOption.value.toLowerCase())
            )
            .map(bg => ({
                name: `${bg.Description} (domesticAds/TAG${bg.ID})`,
                value: `domesticAds/TAG${bg.ID}`
            }));
    
        results.push(...filtered.slice(0, 25));
    }
    


    try {
        await interaction.respond(results.slice(0, 25));
    } catch {
    }
}

    const allowList = JSON.parse(await fs.promises.readFile(path.join(__dirname, "allowedUsers.json"), "utf-8"))
    
    if (!interaction.isChatInputCommand()) return; // Cancel all interactions that aren't slash commands
    if (!(allowList.includes(interaction.user.id))) return interaction.reply({
        ephemeral: true,
        content: "This bot is only usable by Rainwater authenticated users!"
    })
    if (interaction.commandName === 'register') {
    const base = {
        topic: "i2/devforcuesdev",
        unitType: "xd",
        flavor: "domestic/V",
        duration: 1950,
        timing: {
            every: 10,
            onthe: 8
        },
        background: 9,
        ldl: "domestic/ldlE",
        enabled: false,
        sidebar: {
            enabled: false,
            flavor: "domestic/sidebarE"
        }
    };
    const name = Math.floor(Math.random() * 100000000).toString().padStart(8, 0);
    base.topic = `i2/${name}`;
    base.unitType = interaction.options.getString("unit-type");
    if(interaction.options.getString("nickname", "false")) {
        base.nickname = interaction.options.getString("nickname", "false")
    }

    // Get API key for the user
    const apiKey = await getApiKey(interaction.user.id);

    // Create config.xml content
    const configXml = `<?xml version="1.0" encoding="UTF-8"?>
<mqtt>
    <server>starsrv-us-dev1.minnwx.com</server>
    <port>443</port>
    <apiKey>${apiKey}</apiKey>
    <topics>
        <topic>i2/radar</topic>
        <topic>i2/data</topic>
        <topic>${base.topic}</topic>
    </topics>
    <tls>True</tls>
    <logLevel>DEBUG</logLevel>
</mqtt>`;

    // Create a zip file and save to public directory
    const archiver = require('archiver');
    const { createWriteStream } = require('fs');

    const zipFilename = `${new Date() / 1}_${name}-rwe.zip`;
    if(!(fs.existsSync(path.join(__dirname, '../../public/encoder')))) {
        fs.mkdirSync(path.join(__dirname, '../../public/encoder'))
    }
    const zipPath = path.join(__dirname, '../../public/encoder', zipFilename);
    const output = createWriteStream(zipPath);
    
    const archive = archiver('zip', {
        zlib: { level: 9 }
    });

    const zipPromise = new Promise((resolve, reject) => {
        output.on('close', resolve);
        archive.on('error', reject);
    });

    archive.pipe(output);

    // Add the encoder executable (renamed to rainwater.exe)
    const encoderPath = path.join(__dirname, '../rainwater-encoder.exe');
    archive.file(encoderPath, { name: 'rainwater.exe' });

    // Add the config.xml file
    archive.append(configXml, { name: 'config.xml' });

    // Finalize the archive
    await archive.finalize();

    // Wait for the zip to be created
    await zipPromise;
    
    const downloadUrl = `https://rnwtr.minnwx.com/p/${zipFilename}`;

    const embed = new EmbedBuilder()
        .setTitle("Successfully registered new I2 unit!")
        .setDescription(`Registered a \`${base.unitType}\` unit, you can now **grant access** & **use this with the bot**.\n\nPlease **subscribe to the topic** \`${base.topic}\` on the **encoder**.\n\n**[Download your encoder package here](${downloadUrl})**\n\nThe package contains:\n• \`rainwater.exe\` - The encoder executable\n• \`config.xml\` - Pre-configured with your credentials`)
        .setColor("Green")
        .setTimestamp()
        .setFooter({
            text: "Brought to you by Rainwater."
        });

    const cuesData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"));
    cuesData[name] = base;
    await fs.promises.writeFile(path.join(__dirname, "../cues.json"), JSON.stringify(cuesData, null, 2));

    usersData[name] = {
        owner: interaction.user.id,
        access: {}
    };
    saveUsersData(usersData);
    await logMsg(interaction.user.id, name, "registered an I2")
    
    return interaction.editReply({
        embeds: [embed],
        ephemeral: true
    });
    } else if (interaction.commandName === 'loadrun') { // If the command is "hidden-ping"
        const starId = interaction.options.getString("star")
        const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
        if (usersData[starId]) {
            const access = checkAccess(usersData[starId], interaction.user.id, "cues")
            const cueData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"))
            if (access) {
                mqttlib.sendI2Playlist(`i2/${starId}`, interaction.options.getString("flavor"), interaction.options.getInteger("duration"), 4, interaction.options.getString("background", false), 15)
                const embed = new EmbedBuilder()
                    .setTitle("Successfully sent playlist!")
                    .setDescription(`**Successfully sent a playlist** for **I2** for \`${cueData[starId].location.display}\` with the following arguments:\n**Flavor**: \`${interaction.options.getString("flavor")}\`\n**Duration**: \`${interaction.options.getInteger("duration")}\`\n**Logo/Background**: \`${interaction.options.getString("background") ? interaction.options.getString("background") : "generic"}\`\nPlease wait **15** seconds for your playlist to run.`)
                    .setColor("Green")
                    .setTimestamp()
                await logMsg(interaction.user.id, starId, "sent a playlist")
                return interaction.editReply({
                    embeds: [embed]
                })
            } else {
                return interaction.editReply({
                    content: "You don't have access to this STAR!",
                    ephemeral: true
                })
            }
        }
    } else if (interaction.commandName === 'playlist') { // If the command is "copy"
        const starId = interaction.options.getString("star")
        const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
        if (usersData[starId]) {
            const access = checkAccess(usersData[starId], interaction.user.id, "cues")
            if (access) {
                if (interaction.options.getSubcommand(true) === 'loadrun') {
                    const cueData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"))
            if (access) {
                        mqttlib.sendI2Playlist(`i2/${starId}`, interaction.options.getString("flavor"), interaction.options.getInteger("duration"), 4, interaction.options.getString("background", false), 15)
                        const embed = new EmbedBuilder()
                            .setTitle("Successfully sent playlist!")
                            .setDescription(`**Successfully sent a playlist** for **I2** for \`${cueData[starId].location.display}\` with the following arguments:\n**Flavor**: \`${interaction.options.getString("flavor")}\`\n**Duration**: \`${interaction.options.getInteger("duration")}\`\n**Logo/Background**: \`${interaction.options.getString("background") ? interaction.options.getString("background") : "generic"}\`\nPlease wait **15** seconds for your playlist to run.`)
                            .setColor("Green")
                            .setTimestamp()
                        await logMsg(interaction.user.id, starId, "sent a playlist")
                        return interaction.editReply({
                            embeds: [embed]
                        })
                    } else {
                        return interaction.editReply({
                            content: "You don't have access to this STAR!",
                            ephemeral: true
                        })
                    }
                } else if (interaction.options.getSubcommand(true) === 'cancel') {
                    mqttlib.exec(`cancelPres(PresentationId=${interaction.options.getString("presentation-id", true)})`, `i2/${starId}`)
                    const embed = new EmbedBuilder()
                            .setTitle("Successfully cancelled playlist!")
                            .setDescription(`Successfully **cancelled the playlist** for the selected STAR with pres ID \`${interaction.options.getString("presentation-id", true)}\``)
                            .setColor("Green")
                            .setTimestamp()
                        await logMsg(interaction.user.id, starId, "cancelled a playlist")
                        return interaction.editReply({
                            embeds: [embed]
                        })
                }  
            } else {
                return interaction.editReply({
                    content: "You don't have access to this STAR!",
                    ephemeral: true
                })
            }
        } else {
            return interaction.editReply({
                content: "You don't have access to this STAR!",
                ephemeral: true
            })
        }
    } else if (interaction.commandName === 'restart') { // If the command is "copy"
        if (interaction.options.getSubcommand(true) === 'system') {
            const starId = interaction.options.getString("star")
            const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
            if (usersData[starId]) {
                const access = checkAccess(usersData[starId], interaction.user.id, "owner")
                if (access) {
                    const cueData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"))[starId]
                    mqttlib.exec("rebootStar(CommandId=Rainwater_Bot)", `i2/${starId}`)
                    const embed = new EmbedBuilder()
                        .setTitle("Successfully restarted system!")
                        .setDescription(`Successfully **restarted** the STAR unit for \`${cueData.location.display}\`!`)
                        .setColor("Green")
                        .setTimestamp()
                await logMsg(interaction.user.id, starId, "rebooted")
                    return interaction.editReply({
                        embeds: [embed]
                    })
                } else {
                    return interaction.editReply({
                        content: "You don't have access to this STAR!",
                        ephemeral: true
                    })
                }
            }
        } else if (interaction.options.getSubcommand(true) === 'i2service') {
            const starId = interaction.options.getString("star")
            const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
            if (usersData[starId]) {
                const access = checkAccess(usersData[starId], interaction.user.id, "management")
                if (access) {
                    const cueData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"))[starId]
                    mqttlib.exec("restartI2Service(CommandId=Rainwater_Bot)", `i2/${starId}`)
                    const embed = new EmbedBuilder()
                        .setTitle("Successfully restarted I2 Service!")
                        .setDescription(`Successfully **restarted I2 Service** on the STAR unit for \`${cueData.location.display}\`!`)
                        .setColor("Green")
                        .setTimestamp()
                await logMsg(interaction.user.id, starId, "restarted i2 service")
                    return interaction.editReply({
                        embeds: [embed]
                    })
                } else {
                    return interaction.editReply({
                        content: "You don't have access to this STAR!",
                        ephemeral: true
                    })
                }
            }
        } else if (interaction.options.getSubcommand(true) === 'process') {
            const starId = interaction.options.getString("star")
            const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
            if (usersData[starId]) {
                const access = checkAccess(usersData[starId], interaction.user.id, "management")
                if (access) {
                    const cueData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"))[starId]
                    mqttlib.exec(`restartProcess(ProcessName=${interaction.options.getString("process")})`, `i2/${starId}`)
                    const embed = new EmbedBuilder()
                        .setTitle("Successfully restarted an I2 process!")
                        .setDescription(`Successfully **restarted an I2 process** on the STAR unit for \`${cueData?.location?.display || "man idk where this thang is"}\`!`)
                        .setColor("Green")
                        .setTimestamp()
                await logMsg(interaction.user.id, starId, "restarted an i2 process")
                    return interaction.editReply({
                        embeds: [embed]
                    })
                } else {
                    return interaction.editReply({
                        content: "You don't have access to this STAR!",
                        ephemeral: true
                    })
                }
            }
        }
    } else if (interaction.commandName === 'cuer') { // If the command is "copy"
        const starId = interaction.options.getString("star")
        const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
        if (usersData[starId]) {
            const access = checkAccess(usersData[starId], interaction.user.id, "cues")
            if (access) {
                if (interaction.options.getSubcommand(true) === 'toggle') {
                    const cuesData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"))
                    cuesData[starId].enabled = !cuesData[starId].enabled
                    await fs.promises.writeFile(path.join(__dirname, "../cues.json"), JSON.stringify(cuesData, null, 2))
                    const embed = new EmbedBuilder()
                        .setTitle("Successfully toggled automatic cueing!")
                        .setDescription(`**Automatic cueing** for **I2** for \`${cuesData[starId].location.display}\` is now set to: \`${cuesData[starId].enabled}\``)
                        .setColor("Green")
                        .setTimestamp()
                await logMsg(interaction.user.id, starId, "toggled cueing for")

                    return interaction.editReply({
                        embeds: [embed]
                    })
                } else if (interaction.options.getSubcommand(true) === 'force') {
                    const cuesData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"))
                    const cueData = cuesData[starId]
                    const startFlavors = [{
                        id: "ldl3",
                        "flavor": cueData.ldl,
                        duration: 54000
                    }]
                    if (cueData.sidebar.enabled) {
                        startFlavors.push({
                            id: "sidebar2",
                            flavor: cueData.sidebar.flavor,
                            duration: 2680
                        })
                    }
                    let bg = `domesticAds/TAG${cueData.background}`
                    if (cueData.background == 0) {
                        bg = null
                    }
                    if (cueData.background == 9) {
                        bg = `domesticAds/TAG${mqttlib.getRandomBackground(cueData.unitType)}`
                    }
                    if (`${cueData.background}`.startsWith("domesticAds/TAG")) {
                        bg = cueData.background
                    }
                    console.log(bg, cueData.topic)
                    await mqttlib.sendI2Playlist(
                        cueData.topic,
                        cueData.flavor,
                        cueData.duration,
                        4,
                        bg,
                        20,
                        [{
                            id: "ldl3"
                        }, {
                            "id": "sidebar2"
                        }, {
                            "id": "ldl1"
                        }],
                        startFlavors
                    );
                    const embed = new EmbedBuilder()
                        .setTitle("Successfully forced a automatic cue!")
                        .setDescription(`**Playlist parameters** for **I2** for \`${cueData.location.display}\`:\n**Flavor**: \`${cueData.flavor}\`\n**Duration**: \`${cueData.duration}\`\n**Background**: \`${bg ? bg : "generic"}\``)
                        .setColor("Green")
                        .setTimestamp()
                await logMsg(interaction.user.id, starId, "forced a cue for")
                    return interaction.editReply({
                        embeds: [embed]
                    })
                } else if (interaction.options.getSubcommand(true) === 'configure') {
                    const cuesData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"))
                    const cueData = cuesData[starId]
                    if (interaction.options.getString("flavor", false)) {
                        cueData.flavor = interaction.options.getString("flavor", false)
                    }
                    if (interaction.options.getString("timing", false)) {
                        if (interaction.options.getString("timing", false).includes("/")) {
                            cueData.timing.every = Number(interaction.options.getString("timing", false).split("/")[0])
                            cueData.timing.onthe = Number(interaction.options.getString("timing", false).split("/")[1])
                        }
                    }
                    if (interaction.options.getInteger("duration", false)) {
                        cueData.duration = interaction.options.getInteger("duration", false)
                    }
                    if (interaction.options.getBoolean("enabled", false)) {
                        cueData.enabled = interaction.options.getBoolean("enabled", false)
                    }
                    if (interaction.options.getString("ldl", false)) {
                        cueData.ldl = interaction.options.getString("ldl", false)
                    }
                    if (interaction.options.getString("sidebar", false)) {
                        if (!(interaction.options.getString("sidebar", false).toLowerCase() == "none")) {
                            cueData.sidebar.enabled = true
                            cueData.sidebar.flavor = interaction.options.getString("sidebar", false)
                        } else {
                            cueData.sidebar.enabled = false
                        }
                    }
                    if (interaction.options.getString("background", false)) {
                        cueData.background = interaction.options.getString("background", false)
                    }
                    await fs.promises.writeFile(path.join(__dirname, "../cues.json"), JSON.stringify(cuesData, null, 2))
                    let bg = `domesticAds/TAG${cueData.background}`
                    if (`${cueData.background}`.startsWith("domesticAds/TAG")) {
                        bg = `${cueData.background}`
                    }
                    if (cueData.background == 0) {
                        bg = null
                    }
                    if (cueData.background == 9) {
                        bg = "random"
                    }
                await logMsg(interaction.user.id, starId, "configured cueing for")
                    const embed = new EmbedBuilder()
                        .setTitle("Successfully configured automatic cueing!")
                        .setDescription(`**Playlist parameters** for **I2** for \`${cueData.location.display}\`:\n**Enabled**: \`${cueData.enabled ? cueData.enabled : "false"}\`\n**Flavor**: \`${cueData.flavor}\`\n**Duration**: \`${cueData.duration}\`\n**Background**: \`${bg ? bg : "generic"}\`\n**LDL**: \`${cueData.ldl}\`\n**Timing**: \`${cueData.timing.every}/${cueData.timing.onthe}\`\n**Sidebar**: \`${cueData.sidebar.flavor}, ${cueData.sidebar.enabled}\``)
                        .setColor("Green")
                        .setTimestamp()
                    return interaction.editReply({
                        embeds: [embed]
                    })
                } else if (interaction.options.getSubcommand(true) === 'manual') {
                    const starId = interaction.options.getString("star")
        const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
        if (usersData[starId]) {
            const access = checkAccess(usersData[starId], interaction.user.id, "cues")
            const cueData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "../cues.json"), "utf-8"))[starId]
            if (access) {
                const startFlavors = [{
                    id: "ldl3",
                    "flavor": cueData.ldl,
                    duration: 54000
                }]
                if (cueData.sidebar.enabled) {
                    startFlavors.push({
                        id: "sidebar2",
                        flavor: cueData.sidebar.flavor,
                        duration: 2680
                    })
                }
                mqttlib.sendI2Playlist(`i2/${starId}`, interaction.options.getString("flavor"), interaction.options.getInteger("duration"), 4, interaction.options.getString("background", false), 15, [{"id":"ldl3","id":"sidebar2"}], startFlavors)
                const embed = new EmbedBuilder()
                    .setTitle("Successfully sent playlist!")
                    .setDescription(`**Successfully sent a playlist** for **I2** for \`${cueData.location.display}\` with the following arguments:\n**Flavor**: \`${interaction.options.getString("flavor")}\`\n**Duration**: \`${interaction.options.getInteger("duration")}\`\n**Logo/Background**: \`${interaction.options.getString("background") ? interaction.options.getString("background") : "generic"}\`\nPlease wait **15** seconds for your playlist to run.`)
                    .setColor("Green")
                    .setTimestamp()
                await logMsg(interaction.user.id, starId, "sent a playlist")
                return interaction.editReply({
                    embeds: [embed]
                })
            } else {
                return interaction.editReply({
                    content: "You don't have access to this STAR!",
                    ephemeral: true
                })
            }
        }
                }
            } else {
                return interaction.editReply({
                    content: "You don't have access to this STAR!",
                    ephemeral: true
                })
            }
        } else {
            return interaction.editReply({
                content: "You don't have access to this STAR!",
                ephemeral: true
            })
        }
    } else if (interaction.commandName === 'auth') {
        const starId = interaction.options.getString("star");
        if (usersData[starId]) {
            const access = checkAccess(usersData[starId], interaction.user.id, "owner");
            if (!access) return interaction.editReply({
                content: "You don't have access to this STAR!",
                ephemeral: true
            });

            const user = interaction.options.getUser("user");

            if (interaction.options.getSubcommand(true) === 'add') {
                const permissions = interaction.options.getString("permissions").toLowerCase().split(",");
                if (!usersData[starId].access) usersData[starId].access = {};
                usersData[starId].access[user.id] = permissions;
                saveUsersData(usersData);

                const embed = new EmbedBuilder()
                    .setTitle("Successfully granted access!")
                    .setDescription(`${user} now **has access** to **your I2** with the following **permissions**:\n\`${permissions.join("\n")}\``)
                    .setColor("Green")
                    .setTimestamp()
                    .setFooter({
                text: "Brought to you by Rainwater."
            });
                await logMsg(interaction.user.id, starId, `authed a user ${user.id}`)

                return interaction.editReply({
                    embeds: [embed]
                });

            } else if (interaction.options.getSubcommand(true) === 'remove') {
                usersData[starId].access[user.id] = [];
                saveUsersData(usersData);

                const embed = new EmbedBuilder()
                    .setTitle("Successfully removed access!")
                    .setDescription(`${user} **no longer** has access to your I2!`)
                    .setColor("Green")
                    .setTimestamp()
                    .setFooter({
                text: "Brought to you by Rainwater."
            });
                await logMsg(interaction.user.id, starId, `unauthed a user ${user.id}`)

                return interaction.editReply({
                    embeds: [embed]
                });

            } else if (interaction.options.getSubcommand(true) === 'delete') {
                delete usersData[starId];
                saveUsersData(usersData);

                const embed = new EmbedBuilder()
                    .setTitle("Successfully removed unit!")
                    .setDescription(`The provided unit is **no longer in our database**.`)
                    .setColor("Green")
                    .setTimestamp();
                await logMsg(interaction.user.id, starId, "deleted i2 from db")

                return interaction.editReply({
                    embeds: [embed]
                });
            }
        } else {
            return interaction.editReply({
                content: "You don't have access to this STAR!",
                ephemeral: true
            });
        }
    } else if (interaction.commandName === 'fake-alert') { // If the command is "hidden-ping"
        const starId = interaction.options.getString("star")
        const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
        if (usersData[starId]) {
            const access = checkAccess(usersData[starId], interaction.user.id, "cues")
            if (access) {
                mqttlib.sendFakeAlert((interaction.options.getString("type", false) || "generic"), interaction.options.getString("name"), interaction.options.getString("bulletin"), "An alert remains in effect.", starId, Date.now() + parseRelativeTime(interaction.options.getString("expiration")))
                const embed = new EmbedBuilder()
                    .setTitle("Successfully sent fake alert!")
                    .setDescription(`Successfully sent your alert to the I2. Keep your eyes peeled!\n**Alert Details**\n**Name**: \`${interaction.options.getString("name")}\`\n**Bulletin Message**: \`${String(interaction.options.getString("bulletin")).length > 250 ? "truncated due to length, please check star/interaction options" : interaction.options.getString("bulletin")}\`\n**Expires In**: \`${interaction.options.getString("expiration")}\``)
                    .setColor("Green")
                    .setFooter({
                text: "Brought to you by Rainwater."
            })
                    .setTimestamp()
                await logMsg(interaction.user.id, starId, "sent a fake alert")
                return interaction.editReply({
                    embeds: [embed]
                })
            } else {
                return interaction.editReply({
                    content: "You don't have access to this STAR!",
                    ephemeral: true
                })
            }
        }
    } else if (interaction.commandName === 'change-config') { // If the command is "hidden-ping"
        const starId = interaction.options.getString("star")
        const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
        if (usersData[starId]) {
                const access = checkAccess(usersData[starId], interaction.user.id, "management")
                if (access) {
                    const configsData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "configs.json"), "utf8"));

                    let configOption = interaction.options.get("config")?.value;
                    if (!configOption) {
                        return interaction.editReply({ ephemeral: true, content: "No config selected." });
                    }

                    const relativeConfigPath = configOption.replace(/--/g, "\\\\");
                    const normalizedPath = path.normalize(relativeConfigPath);

                    const fullConfigPath = path.join(__dirname, "configs", normalizedPath.replace(/^configs[\\/]+/, '').replaceAll("\\", "/"));
                    if (!fullConfigPath.startsWith(path.join(__dirname, "configs"))) {
                        return interaction.editReply({ ephemeral: true, content: "Invalid config path. Access denied." });
                    }

                    if (!fs.existsSync(fullConfigPath)) {
                        console.log(fullConfigPath)
                        return interaction.editReply({ ephemeral: true, content: "This config doesn't exist locally!" });
                    }

                    const fileContent = await fs.promises.readFile(fullConfigPath, "utf-8");
                    mqttlib.sendMachineProductCfg(fileContent, `i2/${starId}`);
                    const matchedConfig = configsData.find(c => c.filePath === `${relativeConfigPath}`);

                    const embed = new EmbedBuilder()
                        .setTitle("Successfully sent I2 Config!")
                        .setDescription(
                            matchedConfig
                                ? `Your I2 should now have a config for \`${matchedConfig.city}, ${matchedConfig.state}\`!`
                                : "Your I2 should now have the selected config!"
                        )
                        .setColor("Green")
                        .setFooter({ text: "Brought to you by Rainwater." })
                        .setTimestamp();

                    await logMsg(interaction.user.id, starId, "sent a config to unit");

                    return interaction.editReply({ embeds: [embed] });

            } else {
                return interaction.editReply({
                    content: "You don't have access to this STAR!",
                    ephemeral: true
                })
            }
        }
    } else if (interaction.commandName === 'location-info') {
        const subcommand = interaction.options.getSubcommand()
        if(subcommand == 'location-id') {
            const locId = interaction.options.getString("id", true)
            const apiReq = await fetch(`https://wist.minnwx.com/api/i2/l/lid/${locId}?apiKey=${wistApiKey}`)
            if(!apiReq.ok) return interaction.editReply({ ephemeral: true, content: "That location ID doesn't exist, or the API request failed!"})
            const apiRes = await apiReq.json()
            if(apiRes.cityNm == undefined) return interaction.editReply({ ephemeral: true, content: "That city doesn't exist." })
            const embed = new EmbedBuilder()
            .setTitle("I2 LocId Lookup")
            .setDescription(`**Location ID Lookup** for \`${locId}\`\n\n**City Name**: \`${apiRes.cityNm}\`\n**Zone ID**: \`${apiRes.zoneId}\`\n**County ID**: \`${apiRes.cntyId}\`\n**Lat/Lon**: \`${apiRes.lat}\`/\`${apiRes.long}\`\n**ZIP**: \`${apiRes.zip2locId || "No zip2locId Found"}\`\n**Tecci ID**: \`${apiRes.primTecci}\`\n**Coop ID**: \`${apiRes.coopId}\``)
            .setColor("Blue")
            .setFooter({ text: "Brought to you by Rainwater Multimedia!"})
            interaction.editReply({embeds:[embed]})
        } else if(subcommand == 'name') {
            const city = interaction.options.getString("city", true)
            const state = interaction.options.getString("state", true)
            const apiReq = await fetch(`https://wist.minnwx.com/api/i2/l/name/${city}/${state}?apiKey=${wistApiKey}`)
            if(!apiReq.ok) return interaction.editReply({ ephemeral: true, content: "That location doesn't exist in the LFRecord, or the API request failed!"})
            const apiRes = await apiReq.json()
            if(apiRes.cityNm == undefined) return interaction.editReply({ ephemeral: true, content: "That city doesn't exist." })
            const embed = new EmbedBuilder()
            .setTitle("I2 Location Lookup")
            .setDescription(`**Location Lookup** for \`${String(city).toUpperCase()}, ${String(state).toUpperCase()}\`\n\n**LocID**: \`${apiRes.locType}_${apiRes.cntryCd}_${apiRes.locId}\`\n**City Name**: \`${apiRes.cityNm}\`\n**Zone ID**: \`${apiRes.zoneId}\`\n**County ID**: \`${apiRes.cntyId}\`\n**Lat/Lon**: \`${apiRes.lat}\`/\`${apiRes.long}\`\n**ZIP**: \`${apiRes.zip2locId || "No zip2locId Found"}\`\n**Tecci ID**: \`${apiRes.primTecci}\`\n**Coop ID**: \`${apiRes.coopId}\``)
            .setColor("Blue")
            .setFooter({ text: "Brought to you by Rainwater Multimedia!"})
            interaction.editReply({embeds:[embed]})
        }
    } else if (interaction.commandName === 'exec') { // If the command is "hidden-ping"
        const starId = interaction.options.getString("star")
        const usersData = JSON.parse(await fs.promises.readFile(path.join(__dirname, "./userstars.json"), "utf-8"))
        if (usersData[starId]) {
                const access = checkAccess(usersData[starId], interaction.user.id, "management")
                if (access) {
                    const command = interaction.options.get("command")?.value;

                    mqttlib.exec(command, `i2/${starId}`);

                    const embed = new EmbedBuilder()
                        .setTitle("Successfully ran I2 Exec command!")
                        .setDescription(
                            `Command sent to the I2:\n \`${command}\``
                        )
                        .setColor("Green")
                        .setFooter({ text: "Brought to you by Rainwater." })
                        .setTimestamp();

                    await logMsg(interaction.user.id, starId, "sent a command to unit");

                    return interaction.editReply({ embeds: [embed] });

            } else {
                return interaction.editReply({
                    content: "You don't have access to this STAR!",
                    ephemeral: true
                })
            }
        }
    }
})


// Log in to the bot
client.login(require("../../config.json").encoderToken);