const sqlite3 = require("sqlite3").verbose();
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
const path = require("path");
const {WebhookClient,EmbedBuilder, Webhook} = require("discord.js")

const config = require("../../config.json")
const DB_PATH = path.join(__dirname, "auth.db");
const JWT_SECRET = config.sessionSecret || "Rainwater_JWT_Secret_Please_change_this_lol"; // change this in production

const db = new sqlite3.Database(DB_PATH);

function getUser(username) {
  return new Promise((resolve, reject) => {
    db.get("SELECT * FROM users WHERE username = ?", [username], (err, row) => {
      if (err) return reject(err);
      resolve(row);
    });
  });
}

let time = 0

async function login(usernameD, password) {
  username = String(usernameD).toLowerCase()
  if (!username || !password) throw new Error("Missing username or password");

  const user = await getUser(username);
  if (!user) return "Invalid credentials";

  const match = await bcrypt.compare(password, user.password);
  if (!match) {
    if((time + 10) < (new Date() / 1)) {
      const embed = new EmbedBuilder().setTitle("User sign-in failed").setDescription(`User \`${username}\` had an incorrect signin attempt.`).setColor("Orange").setTimestamp().setFooter({text:"Rainwater V2"})
              new WebhookClient({url:config.webhook}).send({embeds:[embed]})
    }
    time = new Date() / 1
    return "Invalid credentials"};

  const token = jwt.sign(
    { id: user.id, username: user.username, apiKey: user.apiKey },
    JWT_SECRET,
    { expiresIn: "2h" }
  );

  const embed = new EmbedBuilder().setTitle("User sign-in succeeded").setDescription(`User \`${username}\` has signed in.`).setColor("Green").setTimestamp().setFooter({text:"Rainwater V2"})
              new WebhookClient({url:config.webhook}).send({embeds:[embed]})

  return `true-${token}`;
}

module.exports = { login };
