import paramiko
import re
import time
from threading import Thread

# SSH connection details
HOST = '192.168.1.226'
USERNAME = 'root'
PASSWORD = 'root'
AUDIO_DIR = '/home/dgadmin/vocalLocal_cuer/Default_Phrases'

def create_ssh_client():
    """Create and return an SSH client connection"""
    client = paramiko.SSHClient()
    client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    client.connect(HOST, username=USERNAME, password=PASSWORD)
    return client

def play_audio(filename):
    """Play audio file on the remote system"""
    try:
        client = create_ssh_client()
        command = f'cd {AUDIO_DIR} && play {filename}'
        print(f"[PLAYING] {filename}")
        stdin, stdout, stderr = client.exec_command(command)
        
        # Wait for command to complete
        stdout.channel.recv_exit_status()
        
        # Check for errors
        error = stderr.read().decode()
        if error:
            print(f"[ERROR] Playing {filename}: {error}")
        else:
            print(f"[SUCCESS] Finished playing {filename}")
        
        client.close()
    except Exception as e:
        print(f"[ERROR] Failed to play {filename}: {e}")

def monitor_log():
    """Monitor the log file for missing wav file warnings"""
    print("[INFO] Connecting to monitor log...")
    client = create_ssh_client()
    
    # Pattern to match the warning message and extract the filename
    pattern = r'\[warn\] File /audio/vocalLocal/Default_Phrases/(.+\.wav) does not exist'
    
    try:
        # Execute tail -f command
        stdin, stdout, stderr = client.exec_command('tail -f /var/log/clientlog')
        
        print("[INFO] Monitoring /var/log/clientlog for missing wav files...")
        print("[INFO] Press Ctrl+C to stop\n")
        
        # Read output line by line
        for line in iter(stdout.readline, ''):
            line = line.strip()
            if line:
                print(f"[LOG] {line}")
                
                # Check if this line contains a missing wav file warning
                match = re.search(pattern, line)
                if match:
                    filename = match.group(1)
                    print(f"\n[DETECTED] Missing file warning: {filename}")
                    
                    # Play the audio in a separate thread so we don't block log monitoring
                    audio_thread = Thread(target=play_audio, args=(filename,))
                    audio_thread.daemon = True
                    audio_thread.start()
                    print()
    
    except KeyboardInterrupt:
        print("\n[INFO] Stopping log monitor...")
    except Exception as e:
        print(f"[ERROR] Monitoring failed: {e}")
    finally:
        client.close()
        print("[INFO] Connection closed")

if __name__ == "__main__":
    print("=" * 60)
    print("SSH Log Monitor and Audio Player")
    print("=" * 60)
    print(f"Host: {HOST}")
    print(f"Audio Directory: {AUDIO_DIR}")
    print("=" * 60 + "\n")
    
    monitor_log()
