import os
import shutil
import time
import subprocess
import argparse
import sys
import ctypes

def title(text):
    if os.name == 'nt':
        os.system(f"title {text}")

def safe_exit():
    try:
        sys.exit(0)
    except SystemExit:
        try:
            if os.name == "nt":
                ctypes.windll.kernel32.ExitProcess(0)
        except Exception:
            pass
        os._exit(0)

def main():
    parser = argparse.ArgumentParser(description="Rainwater Encoder Updater")
    parser.add_argument("-old", "--old", required=True, help="Path to the encoder executable")
    parser.add_argument("-new", "--new", required=True, help="Path to the new encoder executable")
    args = parser.parse_args()

    original_path = args.old
    downloaded = args.new

    title("Rainwater Encoder - updating...")
    time.sleep(5)

    try:
        title("Rainwater Encoder - cleaning up...")

        backup_path = original_path + ".bak"
        if os.path.exists(original_path):
            shutil.copy2(original_path, backup_path)

        if not os.path.exists(downloaded):
            print("Update executable not found.")
            return

        os.remove(original_path)
        shutil.copy2(downloaded, original_path)
        os.remove(downloaded)

        title("Rainwater Encoder - launching updated version...")

        try:
            subprocess.Popen([original_path, "-s", "update", sys.executable], shell=True)
        except Exception:
            subprocess.Popen([original_path], shell=True)

        safe_exit()

    except Exception as e:
        print(f"Failed to update: {e}")
        if os.path.exists(backup_path):
            print("Restoring from backup...")
            shutil.copy2(backup_path, original_path)

if __name__ == "__main__":
    main()
