from flask import Flask, jsonify, send_from_directory
from flask_cors import CORS

from gen_data import process_data_frames
from gen_rad import process_rad_all
from gen_travel import process_travel_frames

app = Flask(__name__)
CORS(app)


# Serve the index as playradnew.html
@app.route("/")
def index():
    return send_from_directory(".", "playradnew.html", max_age=0)


# Serve the "temp" directory
@app.route("/temp/<path:filename>")
def serve_static(filename):
    return send_from_directory("temp", filename, max_age=3600)


@app.route("/api/update_radar")
def update_radar():
    radar_frames = process_rad_all()
    return jsonify(radar_frames)


@app.route("/api/update_data_frames")
def update_data_frames():
    status = process_data_frames()
    status_trv = process_travel_frames()
    return jsonify({"status": status, "status_trv": status_trv})


if __name__ == "__main__":
    process_data_frames()
    process_travel_frames()
    process_rad_all()
    app.run(debug=False, port=5001, host="0.0.0.0")
